import { parseArgs } from "node:util";
import * as lsp from "vscode-languageserver/node.js";
import packageJson from "../package.json" with { type: "json" };
import { runServer } from "./server.js";
const { values } = parseArgs({
    options: {
        stdio: {
            type: "boolean",
        },
        "node-ipc": {
            type: "boolean",
        },
        socket: {
            type: "string",
        },
        pipe: {
            type: "string",
        },
        version: {
            type: "boolean",
            short: "v",
        },
        help: {
            type: "boolean",
            short: "h",
        },
    },
    strict: false,
    allowPositionals: true,
});
if (values.version) {
    console.log(packageJson.version);
    process.exit(0);
}
if (values.help) {
    console.log(`
Options:
  --stdio              Use stdio
  --node-ipc           Use node-ipc
  --socket <number>    Use socket
  --pipe <string>      Use pipe
  -v, --version        Show version number
  -h, --help           Show help
`);
    process.exit(0);
}
const argv = {
    stdio: values.stdio ? true : undefined,
    nodeIpc: values["node-ipc"] ? true : undefined,
    socket: values.socket ? Number(values.socket) : undefined,
    pipe: values.pipe ? String(values.pipe) : undefined,
};
const setArgs = [argv.stdio, argv.socket, argv.nodeIpc, argv.pipe];
if (setArgs.every(a => !a)) {
    console.error("Connection type required (stdio, node-ipc, socket, pipe). Refer to --help for more details.");
    process.exit(1);
}
if (setArgs.filter(a => !!a).length !== 1) {
    console.error("You can only set exactly one connection type (stdio, node-ipc, socket, pipe). Refer to --help for more details.");
    process.exit(1);
}
const connection = lsp.createConnection();
runServer(connection);
