# frozen_string_literal: true

class CreateBackupVulnerabilitySeverityOverridesTable < Gitlab::Database::Migration[2.3]
  PARTITIONED_TABLE_OPTIONS = {
    primary_key: %i[original_record_identifier date],
    options: 'PARTITION BY RANGE (date)'
  }.freeze

  milestone '18.4'

  def change
    create_table :backup_vulnerability_severity_overrides, **PARTITIONED_TABLE_OPTIONS do |t| # rubocop:disable Migration/EnsureFactoryForTable -- Factory is not necessary at this point.
      t.timestamps_with_timezone null: false

      t.bigint :original_record_identifier
      t.bigint :vulnerability_id, index: { name: "index_backup_vulnerability_severity_overrides_on_fk" }, null: false
      t.bigint :project_id, index: true, null: false
      t.date :date, null: false
      t.jsonb :data, null: false
    end
  end
end
