---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: カスタムエージェント
---

{{< details >}}

- プラン: Premium、Ultimate
- アドオン: GitLab Duo Core、Pro、またはEnterprise。
- 提供形態: GitLab.com、GitLab Self-Managed
- ステータス: 実験的機能

{{< /details >}}

{{< collapsible title="モデル情報" >}}

- [セルフホストモデル対応のGitLab Duo](../../../administration/gitlab_duo_self_hosted/_index.md)で利用可能: いいえ

{{< /collapsible >}}

{{< history >}}

- GitLab 18.5で`global_ai_catalog`という名前の[フラグ](../../../administration/feature_flags/_index.md)により[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/549914)されました。GitLab.comで有効になりました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

エージェントは人工知能を使用してタスクを実行し、複雑な質問に答えます。カスタムエージェントを作成して、マージリクエストの作成やレビューなど、特定のタスクを実行します。または、AIカタログを使用して、GitLabで作成されたエージェントを見つけます。

エージェントとやり取りする準備ができたら、GitLab Duoチャットで使用を開始できるように、エージェントを有効にできます。

## エージェントの表示レベル {#agent-visibility}

カスタムエージェントを作成する際は、それを管理するプロジェクトを選択し、エージェントを公開またはプライベートにするかを選択します。

公開エージェント:

- 誰でも閲覧でき、前提条件を満たすプロジェクトで有効にできます。

プライベートエージェント:

- 管理プロジェクトのメンバーのうち、少なくともデベロッパーロールを持つメンバーのみが閲覧できます。
- 管理プロジェクト以外のプロジェクトでは有効にできません。

エージェントが現在有効になっている場合、プライベートエージェントを公開にすることはできません。

## お使いのプロジェクトのエージェントを表示 {#view-the-agents-for-your-project}

前提要件:

- プロジェクトのデベロッパーロール以上を持っている必要があります。

お使いのプロジェクトで有効になっているエージェントの一覧を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **自動化** > **エージェント**を選択します。

エージェントを選択して詳細を表示します。

## エージェントを作成 {#create-an-agent}

プロジェクトから、またはAIカタログを使用して、エージェントを作成できます。

前提要件:

- プロジェクトのメンテナーロール以上が必要です。

{{< tabs >}}

{{< tab title="プロジェクトから" >}}

エージェントを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **自動化** > **エージェント**を選択します。
1. **新規エージェント**を選択します。
1. **基本情報**の下:
   1. **表示名**に、エージェントの名前を入力します。
   1. **説明**に、エージェントの説明を入力します。
1. **表示レベルとアクセス**の**表示レベル**で、**プライベート**または**公開**を選択します。
1. **プロンプト**の**システムプロンプト**に、エージェントの個性、専門知識、および動作を定義するプロンプトを入力します。
1. オプション。**利用可能なツール**の下の**ツール**ドロップダウンリストから、エージェントがアクセスできるツールを選択します。たとえば、エージェントが自動的にイシューを作成するようにするには、**イシューの作成**を選択します。

   利用可能なツールの一覧については、[組み込みツール定義](https://gitlab.com/gitlab-org/gitlab/-/blob/master/ee/lib/ai/catalog/built_in_tool_definitions.rb)を参照してください。
1. **エージェントの作成**を選択します。

{{< /tab >}}

{{< tab title="AIカタログから" >}}

エージェントを作成するには:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. **新規エージェント**を選択します。
1. **基本情報**の下:
   1. **表示名**に、エージェントの名前を入力します。
   1. **説明**に、エージェントの説明を入力します。
1. **表示レベルとアクセス**の下:
   1. **Managed by**（管理元）ドロップダウンリストから、エージェントのプロジェクトを選択します。
   1. **表示レベル**で、**プライベート**または**公開**を選択します。
1. **プロンプト**の**システムプロンプト**に、エージェントの個性、専門知識、および動作を定義するプロンプトを入力します。
1. オプション。**利用可能なツール**の下の**ツール**ドロップダウンリストから、エージェントがアクセスできるツールを選択します。たとえば、エージェントが自動的にイシューを作成するようにするには、**イシューの作成**を選択します。

   利用可能なツールの一覧については、[組み込みツール定義](https://gitlab.com/gitlab-org/gitlab/-/blob/master/ee/lib/ai/catalog/built_in_tool_definitions.rb)を参照してください。
1. **エージェントの作成**を選択します。

{{< /tab >}}

{{< /tabs >}}

エージェントがAIカタログに表示されます。チャットでエージェントを使用するには、プロジェクトで有効にします。

## エージェントを有効にする {#enable-an-agent}

チャットでエージェントを使用するには、プロジェクトでエージェントを有効にします。

前提要件:

- プロジェクトのメンテナーロール以上が必要です。

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. 有効にするエージェントを選択します。
1. 右上隅で、**プロジェクトで有効にする**を選択します。
1. **プロジェクト**ドロップダウンリストから、プロジェクトを選択します。
1. **有効**を選択します。

エージェントがプロジェクトの**自動化** > **エージェント**ページに表示されます。プロジェクトで、エージェントとの新しいチャットを開始できます。詳細については、[エージェントの選択](../../gitlab_duo_chat/agentic_chat.md#select-an-agent)を参照してください。

### プロジェクトのエージェントを無効にする {#disable-an-agent-for-a-project}

前提要件:

- プロジェクトのメンテナーロール以上が必要です。

エージェントを無効にするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **自動化** > **エージェント**を選択します。
1. 無効にするエージェントを見つけて、**アクション** ({{< icon name="ellipsis_v" >}}) > **無効**を選択します。
1. 確認ダイアログで、**無効化**を選択します。

エージェントはプロジェクトに表示されなくなり、チャットでは使用できなくなります。

## エージェントを複製する {#duplicate-an-agent}

元のエージェントを上書きせずに変更を加えるには、既存のエージェントのコピーを作成します。

前提要件:

- プロジェクトのメンテナーロール以上が必要です。

エージェントを複製するには:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. 複製するエージェントを選択します。
1. 右上隅で、**アクション** ({{< icon name="ellipsis_v" >}}) > **複製**を選択します。
1. オプション。変更するフィールドを編集します。
1. **エージェントの作成**を選択します。

## エージェントの管理 {#manage-agents}

エージェントを編集して設定を変更するか、削除してAIカタログから削除します。

前提要件:

- 管理対象のGitLabプロジェクトのメンバーであり、メンテナーロール以上を持っている必要があります。

エージェントを管理するには:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. 管理するエージェントを選択します。
   - エージェントを編集するには:
     1. 右上隅で、**編集**を選択します。
     1. 変更するフィールドを編集し、**変更を保存**を選択します。
   - エージェントを削除するには:
     1. 右上隅にある**アクション**（{{< icon name="ellipsis_v" >}}）> **削除**を選択します。
     1. 確認ダイアログで、**削除**を選択します。

## エージェントをレポートする {#report-an-agent}

エージェントに潜在的に不快なものが含まれている場合、または組織にリスクをもたらす場合は、レポートできます。

エージェントをレポートするには:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. レポートするエージェントを選択します。
1. 右上隅で、**アクション** ({{< icon name="ellipsis_v" >}}) > **Report to admin**（管理者に報告）を選択します。
1. 不正行為のレポートを完了し、**送信**を選択します。

管理者に通知され、エージェントを非表示または削除することを選択できます。
