---
stage: Runtime
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 組織に合わせてプロジェクトを設定します。
title: プロジェクトで作業の整理を始める
---

GitLabのプロジェクトを使用すると、特定の開発プロジェクトに関するすべてのデータを整理できます。プロジェクトは、チームと協力して作業し、ファイルを保存して、タスクを管理する場所です。

プロジェクトを使用すると、次のことが可能です。

- コードを記述および保存する
- イシューとタスクを追跡する
- コード変更の共同作業を行う
- アプリをテストしてデプロイする

プロジェクトの作成とメンテナンスは、以下に示すより大きなワークフローの一部です。

![プロジェクトを使用した作業の整理プロセスが、開発ワークフローのPlanステージに含まれています。](img/get_started_projects_v16_11.png)

## ステップ1: プロジェクトを作成する {#step-1-create-a-project}

まず、コードベース、ドキュメント、関連リソースを格納するための新しいプロジェクトをGitLabで作成します。

プロジェクトには1つのリポジトリが含まれます。リポジトリには、作業に関連するすべてのファイル、ディレクトリ、データが格納されます。

プロジェクトを作成する際に、開発ワークフローやコラボレーションの要件に合わせて、次の項目を確認して設定します。

- 表示レベル
- マージリクエストの承認
- イシュートラッキング
- CI/CDパイプライン
- イシューやマージリクエストなどのエンティティの説明テンプレート

詳細については、以下を参照してください。

- [プロジェクトを作成する](../project/_index.md)
- [プロジェクトを管理する](../project/working_with_projects.md)
- [プロジェクトの表示レベル](../public_access.md)
- [プロジェクトの設定](../project/settings/_index.md)
- [説明テンプレート](../project/description_templates.md)

## ステップ2: プロジェクトへのアクセスを保護および制御する {#step-2-secure-and-control-access-to-projects}

次のツールを使用して、プロジェクトへの安全なアクセスを管理します。

- プロジェクトアクセストークン: 自動化されたツールまたは外部システムに特定のアクセス権を付与し、安全なインテグレーションを可能にします。
- デプロイキー: リポジトリへの読み取り専用アクセス権を付与し、外部システムへのプロジェクトの安全なデプロイを可能にします。
- デプロイトークン: プロジェクトのリポジトリとレジストリへの一時的かつ限定的なアクセス権を付与し、安全なデプロイと自動化を可能にします。

詳細については、以下を参照してください。

- [プロジェクトアクセストークン](../project/settings/project_access_tokens.md)
- [デプロイキー](../project/deploy_keys/_index.md)
- [デプロイトークン](../project/deploy_tokens/_index.md)

## ステップ3: プロジェクトの共同作業を行い、共有する {#step-3-collaborate-and-share-projects}

複数のプロジェクトをグループに招待できます。これは、`sharing a project with a group`と呼ばれることもあります。各プロジェクトには、独自のリポジトリ、イシュー、マージリクエストなどの機能があります。

グループ内に複数のプロジェクトをまとめることで、チームメンバーはグループ全体の作業状況の概要を把握しながら、個々のプロジェクトで共同作業を行えます。

プロジェクトへのアクセスをより細かく制御するために、グループにサブグループを追加することもできます。

詳細については、以下を参照してください。

- [プロジェクトを共有する](../project/members/sharing_projects_groups.md)
- [サブグループ](../group/subgroups/_index.md)

## ステップ4: プロジェクトの発見可能性と認知度を高める {#step-4-enhance-project-discoverability-and-recognition}

検索ボックスを使用すると、GitLabインスタンス全体から特定のプロジェクト、イシュー、マージリクエスト、コードスニペットをすばやく見つけることができます。

プロジェクトを見つけやすくするには、次のようにします。

- 予約済みのプロジェクト名とグループ名を考慮し、一貫性があり認識しやすいプロジェクトの命名スキームを作成します。
- プロジェクトの`README`ファイルにバッジを追加します。バッジには、ビルドステータス、プロジェクトの健全性、テストカバレッジ、バージョン番号など、重要な情報を表示できます。
- プロジェクトのトピックを割り当てます。トピックは、プロジェクトを整理して見つけやすくするためのラベルです。

詳細については、以下を参照してください。

- [予約済みのプロジェクト名とグループ名](../reserved_names.md)
- [検索](../search/_index.md)
- [バッジ](../project/badges.md)
- [プロジェクトのトピック](../project/project_topics.md)

## ステップ5: 開発効率を高め、コード品質を維持する {#step-5-boost-development-efficiency-and-maintain-code-quality}

生産性を高め、高品質なコードベースを維持するために、次のようなコードインテリジェンス機能を使用します。

- コードナビゲーション
- ホバー情報
- 自動補完

コードインテリジェンスとは、コードベースを効率的に調査、分析、保守するのに役立つ各種のツールです。

プロジェクト内の特定のファイルをすばやく見つけて移動するには、ファイルファインダーを使用します。

詳細については、以下を参照してください。

- [コードインテリジェンス](../project/code_intelligence.md)
- [ファイル](../project/repository/files/_index.md)

## ステップ6: プロジェクトをGitLabに移行する {#step-6-migrate-projects-into-gitlab}

ファイルエクスポートを使用して、他のシステムまたはGitLabインスタンスからプロジェクトをGitLabに移行します。

アクセス頻度の高いリポジトリをGitLabに移行する場合、プロジェクトエイリアスを使用すると、元の名前で引き続きアクセスできます。

GitLab.comでは、プロジェクトをあるネームスペースから別のネームスペースに転送できます。転送すると、プロジェクトは基本的に別のグループに移動し、そのグループのメンバーがアクセス権または所有権を持つようになります。

詳細については、以下を参照してください。

- [ファイルエクスポートを使用してプロジェクトを移行する](../project/import/_index.md)
- [プロジェクトエイリアス](../project/working_with_projects.md#project-aliases)
- [プロジェクトを別のネームスペースに転送する](../project/working_with_projects.md#transfer-a-project)
