---
stage: Application Security Testing
group: Composition Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: License scanning of CycloneDX files
---

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/384932) in GitLab 15.9 for GitLab SaaS [with two flags](../../../administration/feature_flags/_index.md) named `license_scanning_sbom_scanner` and `package_metadata_synchronization`. Both flags disabled by default.
- [Generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/385176) in GitLab 16.4. Feature flags `license_scanning_sbom_scanner` and `package_metadata_synchronization` removed.
- The legacy license compliance analyzer (`License-Scanning.gitlab-ci.yml`) was [removed](https://gitlab.com/gitlab-org/gitlab/-/issues/439162) in GitLab 17.0.
- GitLab 17.5 introduced support for using a CycloneDX report artifact as a source of
  data for license information. This feature was released behind the feature flag
  `license_scanning_with_sbom_licenses`, and disabled by default.
- In GitLab 17.6, using a CycloneDX report artifact as a source of data for license information was enabled by default. The feature flag `license_scanning_with_sbom_licenses` was still present to disable the feature if necessary.
- In GitLab 17.8 the feature flag `license_scanning_with_sbom_licenses` was removed.

{{< /history >}}

To detect the licenses in use, license compliance relies on running the
[dependency scanning jobs](../../application_security/dependency_scanning/_index.md),
and analyzing the [CycloneDX](https://cyclonedx.org/) Software Bill of Materials (SBOM) generated by those jobs.
This method of scanning is capable of parsing and identifying over 600 different types of licenses, as defined in [the SPDX list](https://spdx.org/licenses/).
Third-party scanners may be used to generate the list of dependencies, as long as they produce a CycloneDX report artifact for [a supported language](#supported-languages-and-package-managers) and follow the GitLab CycloneDX property taxonomy.
The ability to provide other licenses is tracked in [epic 10861](https://gitlab.com/groups/gitlab-org/-/epics/10861).

{{< alert type="note" >}}

The License Scanning feature relies on publicly available package metadata collected in an
external database and synced with the GitLab instance automatically. This database is a multi-region Google Cloud Storage bucket hosted in the United States.
The scan is executed exclusively within the GitLab instance.
No contextual information (for example, a list of project dependencies) is sent to the external service.

{{< /alert >}}

## Configuration

To enable License scanning of CycloneDX files:

- Using the dependency scanning template
  - Enable [dependency scanning](../../application_security/dependency_scanning/_index.md#getting-started)
      and ensure that its prerequisites are met.
  - On GitLab Self-Managed, you can [choose package registry metadata to synchronize](../../../administration/settings/security_and_compliance.md#choose-package-registry-metadata-to-sync) in the **Admin** area for the GitLab instance. For this data synchronization to work, you must allow outbound network traffic from your GitLab instance to the domain `storage.googleapis.com`. If you have limited or no network connectivity then refer to the documentation section [running in an offline environment](#running-in-an-offline-environment) for further guidance.
- Or use the [CI/CD component](../../../ci/components/_index.md) for applicable package registries.

## Supported languages and package managers

License scanning is supported for the following languages and package managers:

<!-- markdownlint-disable MD044 -->
<table class="supported-languages">
  <thead>
    <tr>
      <th>Language</th>
      <th>Package manager</th>
      <th>Dependency scanning template</th>
      <th>CI/CD Component</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>.NET</td>
      <td rowspan="2"><a href="https://www.nuget.org/">NuGet</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td>C#</td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td>C</td>
      <td rowspan="2"><a href="https://conan.io/">Conan</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td>C++</td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td>Go<sup>1</sup></td>
      <td><a href="https://go.dev/">Go</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td rowspan="3">Java</td>
      <td><a href="https://gradle.org/">Gradle</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td><a href="https://maven.apache.org/">Maven</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td><a href="https://developer.android.com/">Android</a></td>
      <td>Yes</td>
      <td><a href="https://gitlab.com/components/android-dependency-scanning">Yes</a></td>
    </tr>
    <tr>
      <td rowspan="3">JavaScript and TypeScript</td>
      <td><a href="https://www.npmjs.com/">npm</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td><a href="https://pnpm.io/">pnpm</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td><a href="https://classic.yarnpkg.com/en/">yarn</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td>PHP</td>
      <td><a href="https://getcomposer.org/">Composer</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td rowspan="4">Python</td>
      <td><a href="https://setuptools.readthedocs.io/en/latest/">setuptools</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td><a href="https://pip.pypa.io/en/stable/">pip</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td><a href="https://pipenv.pypa.io/en/latest/">Pipenv</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td><a href="https://python-poetry.org/">Poetry</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td>Ruby</td>
      <td><a href="https://bundler.io/">Bundler</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td>Rust</td>
      <td><a href="https://doc.rust-lang.org/cargo/">cargo</a></td>
      <td>No</td>
      <td><a href="https://gitlab.com/components/dependency-scanning#generating-cargo-sboms">Yes</a></td>
    </tr>
    <tr>
      <td>Scala</td>
      <td><a href="https://www.scala-sbt.org/">sbt</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
    <tr>
      <td>Swift</td>
      <td><a href="https://developer.apple.com/swift/">sbt</a></td>
      <td>Yes</td>
      <td>No</td>
    </tr>
  </tbody>
</table>
<!-- markdownlint-enable MD044 -->

**Footnotes**:

1. Go standard libraries such as `stdlib` are not supported and will appear with an `unknown` license. Support for these is tracked in [issue 480305](https://gitlab.com/gitlab-org/gitlab/-/issues/480305).

The supported files and versions are the ones supported by
[dependency scanning](../../application_security/dependency_scanning/_index.md#supported-languages-and-package-managers).

## Data sources

License information for supported packages is obtained from the sources below. GitLab does
additional processing on the original data, which includes mapping variations to the canonical
license names.

| Package manager | Source                                                           |
|-----------------|------------------------------------------------------------------|
| Cargo           | <https://deps.dev/>                                              |
| Conan           | <https://github.com/conan-io/conan-center-index>                 |
| Go              | <https://index.golang.org/>                                      |
| Maven           | <https://storage.googleapis.com/maven-central>                   |
| npm             | <https://deps.dev/>                                              |
| NuGet           | <https://api.nuget.org/v3/catalog0/index.json>                   |
| Packagist       | <https://packagist.org/packages/list.json>                       |
| PyPI            | <https://warehouse.pypa.io/api-reference/bigquery-datasets.html> |
| RubyGems        | <https://rubygems.org/versions>                                  |

## License expressions

The License Scanning of CycloneDX files does not support [composite licenses](https://spdx.github.io/spdx-spec/v2-draft/SPDX-license-expressions/).
Adding this capability is tracked in issue [336878](https://gitlab.com/gitlab-org/gitlab/-/issues/336878).

## Blocking merge requests based on detected licenses

Users can require approval for merge requests based on the licenses that are detected by configuring a [license approval policy](../license_approval_policies.md).

## Running in an offline environment

{{< details >}}

- Tier: Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

For instances in an environment with limited, restricted, or intermittent access to external resources through the internet, some adjustments are required to successfully scan
CycloneDX reports for licenses. For more information, see the offline [quick start guide](../../../topics/offline/quick_start_guide.md#enabling-the-package-metadata-database).

## Use CycloneDX report as a source of license information

{{< history >}}

- Introduced in GitLab 17.5 [with a flag](../../../administration/feature_flags/_index.md) named `license_scanning_with_sbom_licenses`. Disabled by default.
- Enabled on GitLab.com, GitLab Self-Managed, and GitLab Dedicated in GitLab 17.6.
- Generally available in GitLab 17.8. Feature flag `license_scanning_with_sbom_licenses` removed.

{{< /history >}}

The License Scanning uses the [licenses](https://cyclonedx.org/use-cases/#license-compliance) field of the CycloneDX JSON SBOM when available. If the license information is unavailable, the license information imported from the external license database will be used(current behavior).
License information can be provided using a valid SPDX identifier or a license name. However, providing a license using an SPDX License Expression is not supported.
More information about the license field format can be found on the [CycloneDX](https://cyclonedx.org/use-cases/#license-compliance) specification.

Compatible CycloneDX SBOM generators that provide the licenses field can be found in the [CycloneDX Tool Center](https://cyclonedx.org/tool-center/).

Only licenses providing an SPDX identifier are currently supported. Extending this feature beyond SDPX licenses is tracked in [issue 505677](https://gitlab.com/gitlab-org/gitlab/-/issues/505677).

### Configure license information source

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/501662) in GitLab 18.3.

{{< /history >}}

Choose which license information source to use when both are available.

To configure the preferred source of license information for a project:

1. On the top bar, select **Search or go to** and find your project.
1. Select **Secure** > **Security configuration**.
1. In the **License information source** section, select either:
   - **SBOM** (default) - Uses license information from CycloneDX reports.
     - The scanner reads license information from reports located in the project at `/gl-sbom-*.cdx.json`.
     - To overwrite a license, update the license data directly in this file.
   - **PMDB** - Uses license information from the external license database.

## Troubleshooting

### A CycloneDX file is not being scanned and appears to provide no results

Ensure that the CycloneDX file adheres to the [CycloneDX JSON specification](https://cyclonedx.org/docs/latest/json). This specification does [not permit duplicate entries](https://cyclonedx.org/docs/latest/json/#components). Projects that contain multiple SBOM files should either report each SBOM file up as individual CI report artifacts or they should ensure that duplicates are removed if the SBOMs are merged as part of the CI pipeline.

You can validate CycloneDX SBOM files against the `CycloneDX JSON specification` as follows:

```shell
$ docker run -it --rm -v "$PWD:/my-cyclonedx-sboms" -w /my-cyclonedx-sboms cyclonedx/cyclonedx-cli:latest cyclonedx validate --input-version v1_4 --input-file gl-sbom-all.cdx.json

Validating JSON BOM...
BOM validated successfully.
```

If the JSON BOM fails validation, for example, because there are duplicate components:

```shell
Validation failed: Found duplicates at the following index pairs: "(A, B), (C, D)"
#/properties/components/uniqueItems
```

This issue can be fixed by updating the CI template to use [jq](https://jqlang.github.io/jq/) to remove the duplicate components from the `gl-sbom-*.cdx.json` report by overriding the job definition that produces the duplicate components. For example, the following removes duplicate components from the `gl-sbom-gem-bundler.cdx.json` report file produced by the `gemnasium-dependency_scanning` job:

```yaml
include:
  - template: Jobs/Dependency-Scanning.gitlab-ci.yml

gemnasium-dependency_scanning:
  after_script:
    - apk update && apk add jq
    - jq '.components |= unique' gl-sbom-gem-bundler.cdx.json > tmp.json && mv tmp.json gl-sbom-gem-bundler.cdx.json
```

### Remove unused license data

License scanning changes (released in GitLab 15.9) required a significant amount of additional disk space to be available on the instances. This issue was resolved in GitLab 16.3 by the [Reduce package metadata table on-disk footprint](https://gitlab.com/groups/gitlab-org/-/epics/10415) epic. But if your instance was running license scanning between GitLab 15.9 and 16.3, you may want to remove the unneeded data.

To remove the unneeded data:

1. Check if the [`package_metadata_synchronization`](https://about.gitlab.com/releases/2023/02/22/gitlab-15-9-released/#new-license-compliance-scanner) feature flag is currently, or was previously enabled, and if so, disable it. Use [Rails console](../../../administration/operations/rails_console.md) to execute the following commands.

   ```ruby
   Feature.enabled?(:package_metadata_synchronization) && Feature.disable(:package_metadata_synchronization)
   ```

1. Check if there is deprecated data in the database:

   ```ruby
   PackageMetadata::PackageVersionLicense.count
   PackageMetadata::PackageVersion.count
   ```

1. If there is deprecated data in the database, remove it by running the following commands in order:

   ```ruby
   ActiveRecord::Base.connection.execute('SET statement_timeout TO 0')
   PackageMetadata::PackageVersionLicense.delete_all
   PackageMetadata::PackageVersion.delete_all
   ```

### Dependency licenses are unknown

Open source license information is stored in the database and used to resolve licenses for a
project's dependencies. A dependency's license may appear as `unknown` if license information does
not exist or if that data is not yet available in the database.

Lookups for a dependency's licenses are done upon pipeline completion, so if this data was not
available at that time an `unknown` license is recorded. This license is shown up until a subsequent
pipeline is executed at which point another license lookup is made. If a lookup confirms the
dependency's license has changed, the new license is shown at this time.
