# frozen_string_literal: true

require 'json'

module GitlabQuality
  module TestTooling
    module CodeCoverage
      class RspecReport
        # @param [Hash<String, Object>] rspec_report The content of an RSpec
        #   report
        def initialize(rspec_report)
          @rspec_report = rspec_report
        end

        # @return [Array<Hash<String, String>>] Content of the "examples"
        #   section of the RSpec report
        def examples
          @examples ||= @rspec_report['examples']
        end

        # @return [Hash<String, Array<String>>] Test files mapped to all feature
        #   categories they belong to
        # @example Return value
        #   {
        #     "spec/path/to/file_spec.rb" => [
        #       "feature_category1", "feature_category2"
        #     ],
        #     ...
        #   }
        def tests_to_categories
          @tests_to_categories ||= examples.to_a.filter_map do |example|
            next unless example.is_a?(Hash)

            file_path = example['file_path']
            next unless file_path.is_a?(String)

            [file_path.gsub('./', ''), Array(example['feature_category']).compact]
          end.to_h
        end
      end
    end
  end
end
