/**
 * ./src/components/network.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import fs from 'fs';
import { Box, Text } from 'ink';
import yaml from 'js-yaml';
// pjson
import { createRequire } from 'module';
import React from 'react';
import Steps from './steps.js';
import Title from './title.js';
const require = createRequire(import.meta.url);
const pjson = require('../../../package.json');
export default function Network({ address, addressType, dns, domain, gateway, iface, netmask }) {
    let productName = '';
    let version = '';
    let configRoot = '/etc/penguins-eggs.d/krill/';
    if (fs.existsSync('/etc/calamares/settings.conf')) {
        configRoot = '/etc/calamares/';
    }
    const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf8'));
    const { branding } = settings;
    const calamares = yaml.load(fs.readFileSync(configRoot + 'branding/' + branding + '/branding.desc', 'utf8'));
    productName = calamares.strings.productName;
    version = calamares.strings.version;
    /**
     * totale width=75
     * step width=15
     * finestra with=59
     */
    const [activeField, setActiveField] = React.useState(0);
    const [submission, setSubmission] = React.useState();
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { borderStyle: "round", flexDirection: "column", height: 11, width: 75 },
            React.createElement(Box, { flexDirection: "column", height: 8, width: 74 },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 6 }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Box, null,
                            React.createElement(Text, null, "interface: "),
                            React.createElement(Text, { color: 'green' }, iface)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "type     : "),
                            React.createElement(Text, { color: 'green' }, addressType)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "address  : "),
                            React.createElement(Text, { color: 'green' }, address)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "netmask  : "),
                            React.createElement(Text, { color: 'green' }, netmask)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "gateway  : "),
                            React.createElement(Text, { color: 'green' }, gateway)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "domain   : "),
                            React.createElement(Text, { color: 'green' }, domain)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "dns      : "),
                            React.createElement(Text, { color: 'green' }, dns))))))));
}
