/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.weakassociations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import schemacrawler.ermodel.weakassociations.PrefixMatches;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Table;
import us.fatehi.utility.Multimap;

final class TableMatchKeys {
    private final List<Table> tables;
    private final Multimap<Table, String> matchKeysForTable;
    private final Multimap<String, Table> tablesForMatchKey;

    private static PrefixMatches analyzeTables(List<Table> tables) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table table : tables) {
            tableNames.add(table.getName());
        }
        return new PrefixMatches(tableNames, "_");
    }

    TableMatchKeys(List<Table> tables) {
        int tableCount;
        List<String> tableMatchKeys;
        this.tables = Objects.requireNonNull(tables, "No tables provided");
        this.matchKeysForTable = new Multimap();
        this.tablesForMatchKey = new Multimap();
        HashMap<Table, Integer> incomingReferenceCounts = new HashMap<Table, Integer>();
        for (Table table : tables) {
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                Table pkTable = foreignKey.getPrimaryKeyTable();
                if (pkTable == null) continue;
                incomingReferenceCounts.merge(pkTable, 1, Integer::sum);
            }
        }
        PrefixMatches prefixMatches = TableMatchKeys.analyzeTables(tables);
        HashMap<String, Integer> maxCountsForKey = new HashMap<String, Integer>();
        for (Table table : tables) {
            tableMatchKeys = prefixMatches.get(table.getName());
            if (tableMatchKeys == null) continue;
            tableCount = incomingReferenceCounts.getOrDefault(table, 0);
            for (String matchKey : tableMatchKeys) {
                maxCountsForKey.merge(matchKey, tableCount, Math::max);
            }
        }
        for (Table table : tables) {
            tableMatchKeys = prefixMatches.get(table.getName());
            if (tableMatchKeys == null) continue;
            tableCount = incomingReferenceCounts.getOrDefault(table, 0);
            for (String matchKey : tableMatchKeys) {
                if (tableCount != maxCountsForKey.getOrDefault(matchKey, 0)) continue;
                this.matchKeysForTable.add(table, matchKey);
                this.tablesForMatchKey.add(matchKey, table);
            }
        }
    }

    public boolean containsKey(String matchKey) {
        return this.tablesForMatchKey.containsKey(matchKey);
    }

    public boolean containsKey(Table table) {
        return this.matchKeysForTable.containsKey(table);
    }

    public List<Table> get(String matchKey) {
        return (List)this.tablesForMatchKey.get(matchKey);
    }

    public List<String> get(Table table) {
        return (List)this.matchKeysForTable.get(table);
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public String toString() {
        return this.tablesForMatchKey.toString();
    }

    boolean isTopRankedCandidate(Table table) {
        List tableMatchKeys = (List)this.matchKeysForTable.get(table);
        if (tableMatchKeys == null || tableMatchKeys.isEmpty()) {
            return true;
        }
        boolean hasCandidates = false;
        for (String matchKey : tableMatchKeys) {
            List matchTables = (List)this.tablesForMatchKey.get(matchKey);
            if (matchTables == null || matchTables.isEmpty()) continue;
            hasCandidates = true;
            if (!matchTables.contains(table)) continue;
            return true;
        }
        return !hasCandidates;
    }
}

