/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.Response;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface DeferredAction {
    public static final DeferredAction NO_OP_INSTANCE = new DeferredAction(){};

    default public void processResponse(Response response) {
    }

    default public void onException(Exception exception) {
        System.getLogger(this.getClass().getName()).log(System.Logger.Level.DEBUG, "Exception in processDeferredActions", (Throwable)exception);
    }

    default public @Nullable WarningMessageCallback getWarningMessageCallback() {
        return null;
    }

    default public boolean requiresSync() {
        return false;
    }

    public static <T> DeferredAction wrapDeferredResponse(DeferredResponse<T> deferredResponse, Function<Response, T> responseMapper, @Nullable WarningMessageCallback warningMessageCallback, Consumer<Exception> exceptionConsumer, boolean requiresSync) {
        return DeferredAction.builder().withProcessResponse(response -> deferredResponse.onResponse(responseMapper.apply((Response)response))).withOnException(exception -> {
            try {
                deferredResponse.onException((Exception)exception);
            }
            finally {
                exceptionConsumer.accept((Exception)exception);
            }
        }).withWarningMessageCallback(warningMessageCallback).withRequiresSync(requiresSync).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final Consumer<Response> RESPONSE_NO_OP = r -> {};
        private static final Consumer<Exception> EXCEPTION_NO_OP = e -> System.getLogger(DeferredAction.class.getName()).log(System.Logger.Level.DEBUG, "Exception in processDeferredActions", (Throwable)e);
        private Consumer<Response> processResponse = RESPONSE_NO_OP;
        private Consumer<Exception> onException = EXCEPTION_NO_OP;
        private @Nullable WarningMessageCallback warningMessageCallback;
        private boolean requiresSync;

        private Builder() {
        }

        public Builder withProcessResponse(Consumer<Response> processResponse) {
            this.processResponse = processResponse;
            return this;
        }

        public Builder withOnException(Consumer<Exception> onException) {
            this.onException = onException;
            return this;
        }

        public Builder withWarningMessageCallback(@Nullable WarningMessageCallback warningMessageCallback) {
            this.warningMessageCallback = warningMessageCallback;
            return this;
        }

        public Builder withRequiresSync(boolean requiresSync) {
            this.requiresSync = requiresSync;
            return this;
        }

        public DeferredAction build() {
            if (this.processResponse == RESPONSE_NO_OP && this.onException == EXCEPTION_NO_OP && this.warningMessageCallback == null && !this.requiresSync) {
                return NO_OP_INSTANCE;
            }
            return new DeferredActionImpl(this.processResponse, this.onException, this.warningMessageCallback, this.requiresSync);
        }

        private record DeferredActionImpl(Consumer<Response> processResponse, Consumer<Exception> onException, @Nullable WarningMessageCallback warningMessageCallback, boolean requiresSync) implements DeferredAction
        {
            @Override
            public void processResponse(Response response) {
                this.processResponse.accept(response);
            }

            @Override
            public void onException(Exception exception) {
                this.onException.accept(exception);
            }

            @Override
            public @Nullable WarningMessageCallback getWarningMessageCallback() {
                return this.warningMessageCallback;
            }
        }
    }

    public static abstract class DelegatingDeferredAction
    implements DeferredAction {
        private final DeferredAction delegate;

        DelegatingDeferredAction(DeferredAction delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public void processResponse(Response response) {
            this.delegate.processResponse(response);
        }

        @Override
        public void onException(Exception exception) {
            this.delegate.onException(exception);
        }

        @Override
        public @Nullable WarningMessageCallback getWarningMessageCallback() {
            return this.delegate.getWarningMessageCallback();
        }

        @Override
        public boolean requiresSync() {
            return this.delegate.requiresSync();
        }
    }
}

