﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qbusiness/QBusiness_EXPORTS.h>
#include <aws/qbusiness/model/PluginBuildStatus.h>
#include <aws/qbusiness/model/PluginState.h>
#include <aws/qbusiness/model/PluginType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QBusiness {
namespace Model {

/**
 * <p>Information about an Amazon Q Business plugin and its
 * configuration.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/Plugin">AWS
 * API Reference</a></p>
 */
class Plugin {
 public:
  AWS_QBUSINESS_API Plugin() = default;
  AWS_QBUSINESS_API Plugin(Aws::Utils::Json::JsonView jsonValue);
  AWS_QBUSINESS_API Plugin& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QBUSINESS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the plugin.</p>
   */
  inline const Aws::String& GetPluginId() const { return m_pluginId; }
  inline bool PluginIdHasBeenSet() const { return m_pluginIdHasBeenSet; }
  template <typename PluginIdT = Aws::String>
  void SetPluginId(PluginIdT&& value) {
    m_pluginIdHasBeenSet = true;
    m_pluginId = std::forward<PluginIdT>(value);
  }
  template <typename PluginIdT = Aws::String>
  Plugin& WithPluginId(PluginIdT&& value) {
    SetPluginId(std::forward<PluginIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the plugin.</p>
   */
  inline const Aws::String& GetDisplayName() const { return m_displayName; }
  inline bool DisplayNameHasBeenSet() const { return m_displayNameHasBeenSet; }
  template <typename DisplayNameT = Aws::String>
  void SetDisplayName(DisplayNameT&& value) {
    m_displayNameHasBeenSet = true;
    m_displayName = std::forward<DisplayNameT>(value);
  }
  template <typename DisplayNameT = Aws::String>
  Plugin& WithDisplayName(DisplayNameT&& value) {
    SetDisplayName(std::forward<DisplayNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the plugin.</p>
   */
  inline PluginType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(PluginType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline Plugin& WithType(PluginType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The plugin server URL used for configuration.</p>
   */
  inline const Aws::String& GetServerUrl() const { return m_serverUrl; }
  inline bool ServerUrlHasBeenSet() const { return m_serverUrlHasBeenSet; }
  template <typename ServerUrlT = Aws::String>
  void SetServerUrl(ServerUrlT&& value) {
    m_serverUrlHasBeenSet = true;
    m_serverUrl = std::forward<ServerUrlT>(value);
  }
  template <typename ServerUrlT = Aws::String>
  Plugin& WithServerUrl(ServerUrlT&& value) {
    SetServerUrl(std::forward<ServerUrlT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of the plugin.</p>
   */
  inline PluginState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(PluginState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline Plugin& WithState(PluginState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the plugin.</p>
   */
  inline PluginBuildStatus GetBuildStatus() const { return m_buildStatus; }
  inline bool BuildStatusHasBeenSet() const { return m_buildStatusHasBeenSet; }
  inline void SetBuildStatus(PluginBuildStatus value) {
    m_buildStatusHasBeenSet = true;
    m_buildStatus = value;
  }
  inline Plugin& WithBuildStatus(PluginBuildStatus value) {
    SetBuildStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp for when the plugin was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  Plugin& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp for when the plugin was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdatedAt() const { return m_updatedAt; }
  inline bool UpdatedAtHasBeenSet() const { return m_updatedAtHasBeenSet; }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  void SetUpdatedAt(UpdatedAtT&& value) {
    m_updatedAtHasBeenSet = true;
    m_updatedAt = std::forward<UpdatedAtT>(value);
  }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  Plugin& WithUpdatedAt(UpdatedAtT&& value) {
    SetUpdatedAt(std::forward<UpdatedAtT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_pluginId;

  Aws::String m_displayName;

  PluginType m_type{PluginType::NOT_SET};

  Aws::String m_serverUrl;

  PluginState m_state{PluginState::NOT_SET};

  PluginBuildStatus m_buildStatus{PluginBuildStatus::NOT_SET};

  Aws::Utils::DateTime m_createdAt{};

  Aws::Utils::DateTime m_updatedAt{};
  bool m_pluginIdHasBeenSet = false;
  bool m_displayNameHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_serverUrlHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_buildStatusHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_updatedAtHasBeenSet = false;
};

}  // namespace Model
}  // namespace QBusiness
}  // namespace Aws
