/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.iotdb.IoTDBPrivilegeInfo;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBAbstractUser;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBPrivilege;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class IoTDBDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(IoTDBDataSource.class);
    private List<IoTDBAbstractUser> users;
    private final boolean isTree;
    private List<IoTDBPrivilege> privileges;

    public IoTDBDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel, boolean tree) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new GenericSQLDialect());
        this.isTree = tree;
    }

    public List<IoTDBAbstractUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        if (this.users == null) {
            this.users = this.loadUsers(monitor);
        }
        return this.users;
    }

    /*
     * Exception decompiling
     */
    private List<IoTDBAbstractUser> loadUsers(DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.users = this.loadUsers(monitor);
        return this;
    }

    public List<IoTDBPrivilege> getAllPrivileges() {
        if (this.privileges == null) {
            this.generatePrivilegesList();
        }
        return this.privileges;
    }

    public List<IoTDBPrivilege> getPrivilegesByKind(boolean isGlobal) {
        ArrayList<IoTDBPrivilege> privs = new ArrayList<IoTDBPrivilege>();
        IoTDBPrivilegeInfo.Kind k = isGlobal ? IoTDBPrivilegeInfo.Kind.GLOBAL : (this.isTree ? IoTDBPrivilegeInfo.Kind.SERIES : IoTDBPrivilegeInfo.Kind.DATABASE);
        for (IoTDBPrivilege priv : this.getAllPrivileges()) {
            if (priv.getKind() != k) continue;
            privs.add(priv);
        }
        return privs;
    }

    public void generatePrivilegesList() {
        String[] globalPrivileges = this.isTree ? IoTDBPrivilegeInfo.treeGlobalPrivileges : IoTDBPrivilegeInfo.tableGlobalPrivileges;
        String[] dbPrivileges = this.isTree ? IoTDBPrivilegeInfo.treeSeriesPrivileges : IoTDBPrivilegeInfo.tableDatabasePrivileges;
        ArrayList<IoTDBPrivilege> newPrivileges = new ArrayList<IoTDBPrivilege>();
        for (String privilege : globalPrivileges) {
            newPrivileges.add(new IoTDBPrivilege(this, privilege, IoTDBPrivilegeInfo.Kind.GLOBAL));
        }
        IoTDBPrivilegeInfo.Kind kind = this.isTree ? IoTDBPrivilegeInfo.Kind.SERIES : IoTDBPrivilegeInfo.Kind.DATABASE;
        for (String privilege : dbPrivileges) {
            newPrivileges.add(new IoTDBPrivilege(this, privilege, kind));
        }
        this.privileges = newPrivileges;
    }

    public IoTDBPrivilege getPrivilege(DBRProgressMonitor monitor, String name) throws DBException {
        return (IoTDBPrivilege)DBUtils.findObject(this.getAllPrivileges(), (String)name, (boolean)true);
    }

    public boolean isTree() {
        return this.isTree;
    }

    public boolean isTable() {
        return !this.isTree;
    }
}

