/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import ghidra.app.plugin.core.strings.Trigram;
import java.util.Iterator;

public class StringTrigramIterator
implements Iterator<Trigram> {
    private final String s;
    private int index = 0;
    private int[] prevCodePoints = new int[2];

    public StringTrigramIterator(String s) {
        String string = this.s = s.codePointCount(0, s.length()) >= 3 ? s : null;
        if (this.hasNext()) {
            this.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.s != null && this.index <= this.s.length();
    }

    @Override
    public Trigram next() {
        int codePoint = this.index >= this.s.length() ? 0 : this.s.codePointAt(this.index);
        this.index += Character.charCount(codePoint);
        Trigram result = new Trigram(new int[]{this.prevCodePoints[0], this.prevCodePoints[1], codePoint});
        this.prevCodePoints[0] = this.prevCodePoints[1];
        this.prevCodePoints[1] = codePoint;
        return result;
    }
}

