/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_Method;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

public abstract class ObjectiveC_MethodList
implements StructConverter {
    private String _className;
    protected ObjectiveC1_State _state;
    protected long _index = -1L;
    protected List<ObjectiveC_Method> methods = new ArrayList<ObjectiveC_Method>();

    protected ObjectiveC_MethodList(ObjectiveC1_State state, BinaryReader reader, String className) {
        this._state = state;
        this._index = reader.getPointerIndex();
        this._className = className;
    }

    public List<ObjectiveC_Method> getMethods() {
        return this.methods;
    }

    public void applyTo(Namespace namespace) throws Exception {
        if (this._index == 0L) {
            return;
        }
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = ObjectiveC1_Utilities.toAddress(this._state.program, this._index);
        DataType dt = this.toDataType();
        try {
            ObjectiveC1_Utilities.applyData(this._state.program, dt, address);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)("Could not create " + dt.getName() + " @" + String.valueOf(address)));
        }
        try {
            Namespace methodListNamespace = ObjectiveC1_Utilities.createNamespace(this._state.program, "objc", this._className);
            ObjectiveC1_Utilities.createSymbol(this._state.program, methodListNamespace, namespace.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ObjectiveC_Method method : this.getMethods()) {
            method.applyTo(namespace);
        }
    }
}

