/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.MangledContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ExtensionPoint;

public interface Demangler
extends ExtensionPoint {
    public boolean canDemangle(Program var1);

    default public DemangledObject demangle(String mangled) throws DemangledException {
        MangledContext mangledContext = this.createMangledContext(mangled, null, null, null);
        DemangledObject demangledObject = this.demangle(mangledContext);
        if (demangledObject != null && demangledObject.getMangledContext() == null) {
            demangledObject.setMangledContext(mangledContext);
        }
        return this.demangle(mangledContext);
    }

    @Deprecated(since="11.3", forRemoval=true)
    default public DemangledObject demangle(String mangled, DemanglerOptions options) throws DemangledException {
        MangledContext mangledContext = this.createMangledContext(mangled, options, null, null);
        DemangledObject demangledObject = this.demangle(mangledContext);
        if (demangledObject != null && demangledObject.getMangledContext() == null) {
            demangledObject.setMangledContext(mangledContext);
        }
        return this.demangle(mangledContext);
    }

    public DemangledObject demangle(MangledContext var1) throws DemangledException;

    default public DemanglerOptions createDefaultOptions() {
        return new DemanglerOptions();
    }

    default public MangledContext createMangledContext(String mangled, DemanglerOptions options, Program program, Address address) {
        if (options == null) {
            options = this.createDefaultOptions();
        }
        return new MangledContext(program, options, mangled, address);
    }
}

