/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.listing;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.MultiStateActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.menu.MultiStateDockingAction;
import docking.options.OptionsService;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldPanel;
import generic.theme.GIcon;
import ghidra.app.plugin.core.functioncompare.actions.EmptySignatureApplyAction;
import ghidra.app.plugin.core.functioncompare.actions.FunctionNameApplyAction;
import ghidra.app.plugin.core.functioncompare.actions.SignatureWithDatatypesApplyAction;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeaderComp;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.app.util.viewer.format.FormatModelListener;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.features.base.codecompare.listing.LinearAddressCorrelation;
import ghidra.features.base.codecompare.listing.ListingCodeComparisonOptions;
import ghidra.features.base.codecompare.listing.ListingComparisonActionContext;
import ghidra.features.base.codecompare.listing.ListingDiffActionManager;
import ghidra.features.base.codecompare.listing.ListingDisplay;
import ghidra.features.base.codecompare.listing.ListingDisplaySynchronizer;
import ghidra.features.base.codecompare.panel.CodeComparisonView;
import ghidra.features.base.codecompare.panel.CodeComparisonViewActionContext;
import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.correlate.HashedFunctionAddressCorrelation;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.program.util.ListingDiff;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.MultiAddressRangeIterator;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Duo;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import help.Help;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ListingCodeComparisonView
extends CodeComparisonView
implements FormatModelListener,
OptionsChangeListener {
    public static final String NAME = "Listing View";
    private static final String DIFF_NAVIGATE_GROUP = "A2_DiffNavigate";
    private static final Icon NEXT_DIFF_ICON = new GIcon("icon.base.util.listingcompare.diff.next");
    private static final Icon PREVIOUS_DIFF_ICON = new GIcon("icon.base.util.listingcompare.previous.next");
    private static final Icon BOTH_VIEWS_ICON = new GIcon("icon.base.util.listingcompare.area.markers.all");
    private static final Icon UNMATCHED_ICON = new GIcon("icon.base.util.listingcompare.area.markers.unmatched");
    private static final Icon DIFF_ICON = new GIcon("icon.base.util.listingcompare.area.markers.diff");
    private static final Icon HOVER_ON_ICON = new GIcon("icon.base.util.listingcompare.hover.on");
    private static final Icon HOVER_OFF_ICON = new GIcon("icon.base.util.listingcompare.hover.off");
    private ListingCodeComparisonOptions comparisonOptions;
    private Duo<ListingDisplay> displays;
    private ListingAddressCorrelation addressCorrelator;
    private ListingDiff listingDiff;
    private ListingDisplaySynchronizer coordinator;
    private boolean listingsLocked;
    private ListingDiffActionManager diffActionManager;
    private DockingAction nextDiffAction;
    private DockingAction previousDiffAction;
    private DockingAction optionsAction;
    private DockingAction applyFunctionNameAction;
    private DockingAction applyEmptySignatureAction;
    private DockingAction applySignatureAction;
    private ToggleDockingAction toggleHeaderAction;
    private ToggleDockingAction toggleHoverAction;
    private MultiStateDockingAction<NavigateType> nextPreviousAreaTypeAction;

    public ListingCodeComparisonView(String owner, PluginTool tool) {
        super(owner, tool);
        Help.getHelpService().registerHelp((Object)this, new HelpLocation("FunctionComparison", "Listing_View"));
        this.initializeOptions();
        this.listingDiff = this.buildListingDiff();
        this.displays = this.buildListingDisplays();
        this.buildPanel();
        this.createActions();
        this.setSynchronizedScrolling(true);
    }

    private ListingDiff buildListingDiff() {
        ListingDiff diff = new ListingDiff();
        this.diffActionManager = new ListingDiffActionManager(diff);
        return diff;
    }

    private Duo<ListingDisplay> buildListingDisplays() {
        ListingDisplay leftDisplay = new ListingDisplay(this.tool, this.owner, this.listingDiff, this.comparisonOptions, Duo.Side.LEFT);
        ListingDisplay rightDisplay = new ListingDisplay(this.tool, this.owner, this.listingDiff, this.comparisonOptions, Duo.Side.RIGHT);
        leftDisplay.getFormatManager().addFormatModelListener(this);
        leftDisplay.setProgramLocationListener((l, t) -> this.programLocationChanged(Duo.Side.LEFT, l, t));
        rightDisplay.setProgramLocationListener((l, t) -> this.programLocationChanged(Duo.Side.RIGHT, l, t));
        return new Duo((Object)leftDisplay, (Object)rightDisplay);
    }

    @Override
    public JComponent getComparisonComponent(Duo.Side side) {
        return ((ListingDisplay)this.displays.get(side)).getListingPanel();
    }

    public ListingPanel getListingPanel(Duo.Side side) {
        return ((ListingDisplay)this.displays.get(side)).getListingPanel();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.comparisonOptions.loadOptions(options);
        this.updateProgramViews();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.updateActionEnablement();
    }

    public void addHighlightProviders(ListingHighlightProvider leftHighlightProvider, ListingHighlightProvider rightHighlightProvider) {
        ((ListingDisplay)this.displays.get(Duo.Side.LEFT)).addHighlightProvider(leftHighlightProvider);
        ((ListingDisplay)this.displays.get(Duo.Side.RIGHT)).addHighlightProvider(rightHighlightProvider);
    }

    public void removeHighlightProviders(ListingHighlightProvider leftHighlightProvider, ListingHighlightProvider rightHighlightProvider) {
        ((ListingDisplay)this.displays.get(Duo.Side.LEFT)).removeHighlightProvider(leftHighlightProvider);
        ((ListingDisplay)this.displays.get(Duo.Side.RIGHT)).removeHighlightProvider(rightHighlightProvider);
    }

    @Override
    public List<DockingAction> getActions() {
        List<DockingAction> actions = super.getActions();
        actions.add((DockingAction)this.nextPreviousAreaTypeAction);
        actions.add((DockingAction)this.toggleHeaderAction);
        actions.add((DockingAction)this.toggleHoverAction);
        actions.add(this.applyFunctionNameAction);
        actions.add(this.applyEmptySignatureAction);
        actions.add(this.applySignatureAction);
        actions.add(this.nextDiffAction);
        actions.add(this.previousDiffAction);
        actions.add(this.optionsAction);
        actions.addAll(this.diffActionManager.getActions());
        return actions;
    }

    @Override
    public void updateActionEnablement() {
        boolean isShowing = this.isShowing();
        boolean listingDiffActionEnablement = isShowing && this.listingDiff.hasCorrelation();
        this.tool.contextChanged(this.tool.getActiveComponentProvider());
        this.diffActionManager.updateActionEnablement(listingDiffActionEnablement);
    }

    public void setLocation(Duo.Side side, Program program, ProgramLocation location) {
        if (this.isShowing()) {
            ((ListingDisplay)this.displays.get(side)).goTo(location);
        }
    }

    public ListingPanel getActiveListingPanel() {
        return ((ListingDisplay)this.displays.get(this.activeSide)).getListingPanel();
    }

    @Override
    public void dispose() {
        this.setSynchronizedScrolling(false);
        this.displays.each(ListingDisplay::dispose);
    }

    @Override
    public ActionContext getActionContext(ComponentProvider provider, MouseEvent event) {
        if (event == null) {
            ListingComparisonActionContext context = new ListingComparisonActionContext(provider, this);
            return context;
        }
        ListingPanel leftPanel = ((ListingDisplay)this.displays.get(Duo.Side.LEFT)).getListingPanel();
        ListingPanel rightPanel = ((ListingDisplay)this.displays.get(Duo.Side.RIGHT)).getListingPanel();
        Object leftMarginContext = this.getContextForMarginPanels(leftPanel, event);
        if (leftMarginContext != null) {
            return new DefaultActionContext(provider).setContextObject(leftMarginContext);
        }
        Object rightMarginContext = this.getContextForMarginPanels(rightPanel, event);
        if (rightMarginContext != null) {
            return new DefaultActionContext(provider).setContextObject(rightMarginContext);
        }
        Object source = event.getSource();
        if (source instanceof FieldHeaderComp) {
            FieldHeaderLocation fieldHeaderLocation = leftPanel.getFieldHeader().getFieldHeaderLocation(event.getPoint());
            return new DefaultActionContext(provider).setContextObject((Object)fieldHeaderLocation);
        }
        return new ListingComparisonActionContext(provider, this);
    }

    public void updateListings() {
        if (!this.isVisible()) {
            return;
        }
        this.displays.each(ListingDisplay::repaint);
    }

    @Override
    public void formatModelChanged(FieldFormatModel model) {
        this.changeRightToMatchLeftFormat(model);
    }

    public ListingPanel getListingPanel(FieldPanel fieldPanel) {
        ListingPanel listingPanel = ((ListingDisplay)this.displays.get(Duo.Side.LEFT)).getListingPanel();
        if (listingPanel.getFieldPanel() == fieldPanel) {
            return listingPanel;
        }
        listingPanel = ((ListingDisplay)this.displays.get(Duo.Side.RIGHT)).getListingPanel();
        if (listingPanel.getFieldPanel() == fieldPanel) {
            return listingPanel;
        }
        return null;
    }

    public void setStatusInfo(String text) {
        this.tool.setStatusInfo(text);
    }

    public Object getContextObjectForMarginPanels(ListingPanel panel, MouseEvent event) {
        Object source = event.getSource();
        List<MarginProvider> marginProviders = panel.getMarginProviders();
        for (MarginProvider marginProvider : marginProviders) {
            JComponent c = marginProvider.getComponent();
            if (c != source) continue;
            MarkerLocation loc = marginProvider.getMarkerLocation(event.getX(), event.getY());
            if (loc != null) {
                return loc;
            }
            return source;
        }
        List<OverviewProvider> overviewProviders = panel.getOverviewProviders();
        for (OverviewProvider overviewProvider : overviewProviders) {
            JComponent c = overviewProvider.getComponent();
            if (c != source) continue;
            return source;
        }
        return null;
    }

    @Override
    public void setSynchronizedScrolling(boolean synchronize) {
        this.listingsLocked = synchronize;
        this.updateCoordinator();
    }

    private void programLocationChanged(Duo.Side side, ProgramLocation location, EventTrigger trigger) {
        if (trigger != EventTrigger.GUI_ACTION) {
            return;
        }
        ((ListingDisplay)this.displays.get(side)).updateCursorMarkers(location);
        ((ListingDisplay)this.displays.get(side.otherSide())).updateCursorMarkers(null);
        if (this.coordinator != null) {
            this.coordinator.setLocation(side, location);
        }
    }

    private void createActions() {
        this.nextDiffAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Dual Listing Go To Next Area Marker", this.owner).description("Go to the next highlighted area.")).helpLocation(new HelpLocation("FunctionComparison", "Dual Listing Go To Next Highlighted Area"))).popupMenuPath(new String[]{"Go To Next Highlighted Area"})).popupMenuIcon(NEXT_DIFF_ICON)).popupMenuGroup(DIFF_NAVIGATE_GROUP)).toolBarIcon(NEXT_DIFF_ICON)).toolBarGroup(DIFF_NAVIGATE_GROUP)).keyBinding("ctrl alt N")).validWhen(c -> this.isValidPanelContext((ActionContext)c))).enabledWhen(c -> this.isShowing() && this.listingDiff.hasCorrelation())).onAction(c -> this.nextAreaDiff(true))).build();
        this.previousDiffAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Dual Listing Go To Previous Area Marker", this.owner).description("Go to the previous highlighted area.")).helpLocation(new HelpLocation("FunctionComparison", "Dual Listing Go To Previous Highlighted Area"))).popupMenuPath(new String[]{"Go To Previous Highlighted Area"})).popupMenuIcon(PREVIOUS_DIFF_ICON)).popupMenuGroup(DIFF_NAVIGATE_GROUP)).toolBarIcon(PREVIOUS_DIFF_ICON)).toolBarGroup(DIFF_NAVIGATE_GROUP)).keyBinding("ctrl alt P")).validWhen(c -> this.isValidPanelContext((ActionContext)c))).enabledWhen(c -> this.isShowing() && this.listingDiff.hasCorrelation())).onAction(c -> this.nextAreaDiff(false))).build();
        this.toggleHeaderAction = ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Dual Listing Toggle Header", this.owner).description("Toggle Format Header")).menuPath(new String[]{"Show Listing Format Header"})).menuGroup("Listing Group")).helpLocation(new HelpLocation("FunctionComparison", "Dual Listing Toggle Format Header"))).onAction(c -> ((ListingDisplay)this.displays.get(Duo.Side.LEFT)).showHeader(this.toggleHeaderAction.isSelected()))).build();
        this.toggleHoverAction = ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Dual Listing Toggle Mouse Hover Popups", this.owner).description("Toggles Mouse Hover Popups")).toolBarIcon(HOVER_ON_ICON)).helpLocation(new HelpLocation("FunctionComparison", "Dual Listing Toggle Mouse Hover Popups"))).enabledWhen(c -> this.isShowing())).selected(true).onAction(c -> this.setHover(this.toggleHoverAction.isSelected()))).build();
        this.nextPreviousAreaTypeAction = ((MultiStateActionBuilder)((MultiStateActionBuilder)((MultiStateActionBuilder)((MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder("Dual Listing Next/Previous Area Marker", this.owner).description("Set Navigate Next/Previous Area Marker options")).helpLocation(new HelpLocation("FunctionComparison", "Dual Listing Next/Previous Area Marker"))).toolBarIcon(DIFF_ICON)).toolBarGroup(DIFF_NAVIGATE_GROUP)).addState("All Area Markers", BOTH_VIEWS_ICON, (Object)NavigateType.ALL).addState("Unmatched Area Markers", UNMATCHED_ICON, (Object)NavigateType.UNMATCHED).addState("Diff AreaMarkers", DIFF_ICON, (Object)NavigateType.DIFF).enabledWhen(c -> this.isShowing() && this.listingDiff.hasCorrelation())).onActionStateChanged((s, t) -> this.adjustNextPreviousAreaType((NavigateType)((Object)((Object)s.getUserData())))).build();
        this.optionsAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Listing Code Comparison Options", this.owner).description("Show the tool options for the Listing Code Comparison.")).popupMenuPath(new String[]{"Properties"})).helpLocation(new HelpLocation("FunctionComparison", "Listing_Code_Comparison_Options"))).validWhen(c -> this.isValidPanelContext((ActionContext)c))).enabledWhen(c -> this.isShowing() && this.listingDiff.hasCorrelation())).onAction(c -> this.showOptionsDialog())).build();
        this.applyFunctionNameAction = new FunctionNameApplyAction(this.owner);
        this.applyEmptySignatureAction = new EmptySignatureApplyAction(this.owner);
        this.applySignatureAction = new SignatureWithDatatypesApplyAction(this.owner);
    }

    private void showOptionsDialog() {
        OptionsService service = (OptionsService)this.tool.getService(OptionsService.class);
        service.showOptionsDialog("Listing Code Comparison", "Listing Code Comparison");
    }

    private void adjustNextPreviousAreaType(NavigateType type) {
        String typeString = this.getTypeName(type);
        this.nextDiffAction.getPopupMenuData().setMenuPath(new String[]{"Go to Next " + typeString + " Area"});
        this.nextDiffAction.setDescription("Go to the next " + typeString + " area");
        this.previousDiffAction.getPopupMenuData().setMenuPath(new String[]{"Go to Previous " + typeString + " Area"});
        this.previousDiffAction.setDescription("Go to the previous " + typeString + " area");
    }

    private String getTypeName(NavigateType type) {
        switch (type.ordinal()) {
            case 2: {
                return "Difference";
            }
            case 1: {
                return "Unmatched";
            }
            case 0: {
                return "Highlighted";
            }
        }
        throw new AssertException("Unexpected navigate type" + String.valueOf((Object)type));
    }

    private void setHover(boolean enabled) {
        this.toggleHoverAction.getToolBarData().setIcon(enabled ? HOVER_ON_ICON : HOVER_OFF_ICON);
        this.displays.each(d -> d.setHoverMode(enabled));
    }

    private boolean isValidPanelContext(ActionContext context) {
        if (!(context instanceof CodeComparisonViewActionContext)) {
            return false;
        }
        CodeComparisonViewActionContext comparisonContext = (CodeComparisonViewActionContext)context;
        CodeComparisonView comparisonPanel = comparisonContext.getCodeComparisonView();
        return comparisonPanel == this;
    }

    @Override
    protected void comparisonDataChanged() {
        this.addressCorrelator = this.createCorrelator();
        this.updateProgramViews();
        this.updateCoordinator();
        this.updateListingDiff();
        this.initializeCursorMarkers();
        this.updateActionEnablement();
        this.validate();
    }

    private void updateCoordinator() {
        if (this.coordinator != null) {
            this.coordinator.dispose();
            this.coordinator = null;
        }
        if (this.listingsLocked) {
            this.coordinator = new ListingDisplaySynchronizer(this.displays, this.addressCorrelator);
            this.coordinator.sync(this.activeSide);
        }
    }

    private ListingAddressCorrelation createCorrelator() {
        Function f1 = this.getFunction(Duo.Side.LEFT);
        Function f2 = this.getFunction(Duo.Side.RIGHT);
        if (f1 != null && f2 != null) {
            try {
                return new HashedFunctionAddressCorrelation(f1, f2, TaskMonitor.DUMMY);
            }
            catch (MemoryAccessException | CancelledException throwable) {
                // empty catch block
            }
        }
        if (((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).isEmpty() || ((ComparisonData)this.comparisonData.get(Duo.Side.RIGHT)).isEmpty()) {
            return null;
        }
        return new LinearAddressCorrelation((Duo<ComparisonData>)this.comparisonData);
    }

    private void updateListingDiff() {
        try {
            this.listingDiff.setCorrelation(this.addressCorrelator);
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)"Failed to load correlator", (Throwable)e);
        }
    }

    private void initializeCursorMarkers() {
        ProgramLocation activeProgramLocation = ((ListingDisplay)this.displays.get(this.activeSide)).getProgramLocation();
        this.programLocationChanged(this.activeSide, activeProgramLocation, null);
    }

    private Object getContextForMarginPanels(ListingPanel lp, MouseEvent event) {
        Object source = event.getSource();
        List<MarginProvider> marginProvidersForLP = lp.getMarginProviders();
        for (MarginProvider marginProvider : marginProvidersForLP) {
            JComponent c = marginProvider.getComponent();
            if (c != source) continue;
            MarkerLocation loc = marginProvider.getMarkerLocation(event.getX(), event.getY());
            if (loc != null) {
                return loc;
            }
            return source;
        }
        List<OverviewProvider> overviewProvidersForLP = lp.getOverviewProviders();
        for (OverviewProvider overviewProvider : overviewProvidersForLP) {
            JComponent c = overviewProvider.getComponent();
            if (c != source) continue;
            return source;
        }
        return null;
    }

    private void initializeOptions() {
        this.comparisonOptions = new ListingCodeComparisonOptions();
        ToolOptions options = this.tool.getOptions("Listing Code Comparison");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.comparisonOptions.initializeOptions(options);
        this.comparisonOptions.loadOptions(options);
    }

    private void changeRightToMatchLeftFormat(FieldFormatModel model) {
        SaveState saveState = new SaveState();
        ((ListingDisplay)this.displays.get(Duo.Side.LEFT)).getFormatManager().saveState(saveState);
        ((ListingDisplay)this.displays.get(Duo.Side.RIGHT)).getFormatManager().readState(saveState);
    }

    private void updateProgramViews() {
        ((ListingDisplay)this.displays.get(Duo.Side.LEFT)).setProgramView(this.getProgram(Duo.Side.LEFT), this.getAddresses(Duo.Side.LEFT), "listing1");
        ((ListingDisplay)this.displays.get(Duo.Side.RIGHT)).setProgramView(this.getProgram(Duo.Side.RIGHT), this.getAddresses(Duo.Side.RIGHT), "listing2");
        ((ListingDisplay)this.displays.get(Duo.Side.LEFT)).goTo(((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getInitialLocation());
        ((ListingDisplay)this.displays.get(Duo.Side.RIGHT)).goTo(((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getInitialLocation());
    }

    private void nextAreaDiff(boolean forward) {
        MultiAddressRangeIterator multiIterator;
        NavigateType type = (NavigateType)((Object)this.nextPreviousAreaTypeAction.getCurrentState().getUserData());
        ListingPanel activeListingPanel = this.getActiveListingPanel();
        ProgramLocation activePanelLocation = activeListingPanel.getProgramLocation();
        if (activePanelLocation == null) {
            this.tool.setStatusInfo("The " + (this.activeSide == Duo.Side.LEFT ? "first" : "second") + " listing is empty.");
            return;
        }
        Address activeAddress = activePanelLocation.getAddress();
        ArrayList<AddressRangeIterator> iteratorList = new ArrayList<AddressRangeIterator>();
        if (type == NavigateType.ALL || type == NavigateType.DIFF) {
            AddressSetView activeDiffs = this.listingDiff.getDiffs(this.activeSide);
            iteratorList.add(activeDiffs.getAddressRanges(activeAddress, forward));
        }
        if (type == NavigateType.ALL || type == NavigateType.UNMATCHED) {
            AddressSetView unmatchedCode = this.listingDiff.getUnmatchedCode(this.activeSide);
            iteratorList.add(unmatchedCode.getAddressRanges(activeAddress, forward));
        }
        if ((multiIterator = new MultiAddressRangeIterator(iteratorList.toArray(new AddressRangeIterator[iteratorList.size()]), forward)).hasNext()) {
            AddressRange nextRange = multiIterator.next();
            Address minAddress = nextRange.getMinAddress();
            if ((forward ? nextRange.contains(activeAddress) : minAddress.equals((Object)activeAddress)) && multiIterator.hasNext()) {
                nextRange = multiIterator.next();
                minAddress = nextRange.getMinAddress();
            }
            if (minAddress.equals((Object)activeAddress)) {
                this.outputNoNextPreviousMessage(forward, this.activeSide);
                return;
            }
            this.tool.clearStatusInfo();
            activeListingPanel.goTo(minAddress);
        } else {
            this.outputNoNextPreviousMessage(forward, this.activeSide);
        }
    }

    private void outputNoNextPreviousMessage(boolean forward, Duo.Side side) {
        NavigateType type = (NavigateType)((Object)this.nextPreviousAreaTypeAction.getCurrentState().getUserData());
        String typeName = this.getTypeName(type).toLowerCase();
        this.tool.setStatusInfo("There isn't another " + (forward ? "next " : "previous ") + typeName + " area in the " + (side == Duo.Side.LEFT ? "first" : "second") + " listing.");
    }

    private static enum NavigateType {
        ALL,
        UNMATCHED,
        DIFF;

    }
}

