/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;

public class RegisterTransitionFieldLocation
extends ProgramLocation {
    private String[] registerNames;

    public RegisterTransitionFieldLocation(Program program, Address addr, String[] registerNames, int row, int column) {
        super(program, addr, addr, null, null, row, 0, column);
        this.registerNames = registerNames;
    }

    public RegisterTransitionFieldLocation() {
    }

    public Register getRegister() {
        if (this.getRow() < this.registerNames.length) {
            return this.program.getRegister(this.registerNames[this.getRow()]);
        }
        return null;
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.registerNames = obj.getStrings("_Register_Names", new String[0]);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putStrings("Register_Names", this.registerNames);
    }
}

