/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTreeNode;
import db.FixedKeyFixedRecNode;
import db.FixedKeyInteriorNode;
import db.FixedKeyNode;
import db.FixedKeyVarRecNode;
import db.FixedRecNode;
import db.LongKeyInteriorNode;
import db.LongKeyNode;
import db.RecordNode;
import db.Schema;
import db.Table;
import db.VarKeyInteriorNode;
import db.VarKeyNode;
import db.VarKeyRecordNode;
import db.VarRecNode;
import db.buffers.BufferMgr;
import db.buffers.DataBuffer;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.HashMap;

class NodeMgr {
    static final int NODE_TYPE_SIZE = 1;
    static final int NODE_TYPE_OFFSET = 0;
    static final int NODE_HEADER_SIZE = 1;
    static final byte LONGKEY_INTERIOR_NODE = 0;
    static final byte LONGKEY_VAR_REC_NODE = 1;
    static final byte LONGKEY_FIXED_REC_NODE = 2;
    static final byte VARKEY_INTERIOR_NODE = 3;
    static final byte VARKEY_REC_NODE = 4;
    static final byte FIXEDKEY_INTERIOR_NODE = 5;
    static final byte FIXEDKEY_VAR_REC_NODE = 6;
    static final byte FIXEDKEY_FIXED_REC_NODE = 7;
    static final byte CHAINED_BUFFER_INDEX_NODE = 8;
    static final byte CHAINED_BUFFER_DATA_NODE = 9;
    private BufferMgr bufferMgr;
    private Schema schema;
    private String tableName;
    private int leafRecordCnt = 0;
    private HashMap<Integer, BTreeNode> nodeTable = new HashMap();

    NodeMgr(Table table, BufferMgr bufferMgr) {
        this.bufferMgr = bufferMgr;
        this.schema = table.getSchema();
        this.tableName = table.getName();
    }

    BufferMgr getBufferMgr() {
        return this.bufferMgr;
    }

    Schema getTableSchema() {
        return this.schema;
    }

    String getTableName() {
        return this.tableName;
    }

    int releaseNodes() throws IOException {
        for (BTreeNode node : this.nodeTable.values()) {
            if (node instanceof RecordNode) {
                this.leafRecordCnt -= node.getKeyCount();
            }
            this.bufferMgr.releaseBuffer(node.getBuffer());
        }
        this.nodeTable = new HashMap();
        int result = -this.leafRecordCnt;
        this.leafRecordCnt = 0;
        return result;
    }

    void releaseReadOnlyNode(int bufferId) throws IOException {
        BTreeNode node = this.nodeTable.get(bufferId);
        if (node.getBuffer().isDirty()) {
            throw new IOException("Releasing modified buffer node as read-only");
        }
        if (node instanceof RecordNode) {
            this.leafRecordCnt -= node.getKeyCount();
        }
        this.bufferMgr.releaseBuffer(node.getBuffer());
        this.nodeTable.remove(bufferId);
    }

    void addNode(BTreeNode node) {
        this.nodeTable.put(node.getBufferId(), node);
    }

    void deleteNode(BTreeNode node) throws IOException {
        int bufferId = node.getBufferId();
        this.nodeTable.remove(bufferId);
        this.bufferMgr.releaseBuffer(node.getBuffer());
        this.bufferMgr.deleteBuffer(bufferId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isVarKeyNode(BufferMgr bufferMgr, int bufferId) throws IOException {
        DataBuffer buf = bufferMgr.getBuffer(bufferId);
        try {
            byte nodeType = NodeMgr.getNodeType(buf);
            boolean bl = nodeType == 4 || nodeType == 3;
            return bl;
        }
        finally {
            bufferMgr.releaseBuffer(buf);
        }
    }

    LongKeyNode getLongKeyNode(int bufferId) throws IOException {
        LongKeyNode node = (LongKeyNode)this.nodeTable.get(bufferId);
        if (node != null) {
            return node;
        }
        DataBuffer buf = this.bufferMgr.getBuffer(bufferId);
        byte nodeType = NodeMgr.getNodeType(buf);
        switch (nodeType) {
            case 1: {
                node = new VarRecNode(this, buf);
                this.leafRecordCnt += node.keyCount;
                break;
            }
            case 2: {
                node = new FixedRecNode(this, buf, this.schema.getFixedLength());
                this.leafRecordCnt += node.keyCount;
                break;
            }
            case 0: {
                node = new LongKeyInteriorNode(this, buf);
                break;
            }
            default: {
                this.bufferMgr.releaseBuffer(buf);
                throw new AssertException("Unexpected Node Type (" + nodeType + ") found, expecting LongKeyNode");
            }
        }
        return node;
    }

    FixedKeyNode getFixedKeyNode(int bufferId) throws IOException {
        FixedKeyNode node = (FixedKeyNode)this.nodeTable.get(bufferId);
        if (node != null) {
            return node;
        }
        DataBuffer buf = this.bufferMgr.getBuffer(bufferId);
        byte nodeType = NodeMgr.getNodeType(buf);
        switch (nodeType) {
            case 6: {
                node = new FixedKeyVarRecNode(this, buf);
                this.leafRecordCnt += node.keyCount;
                break;
            }
            case 7: {
                node = new FixedKeyFixedRecNode(this, buf);
                this.leafRecordCnt += node.keyCount;
                break;
            }
            case 5: {
                node = new FixedKeyInteriorNode(this, buf);
                break;
            }
            default: {
                this.bufferMgr.releaseBuffer(buf);
                throw new IOException("Unexpected Node Type (" + nodeType + ") found, expecting FixedKeyNode");
            }
        }
        return node;
    }

    VarKeyNode getVarKeyNode(int bufferId) throws IOException {
        VarKeyNode node = (VarKeyNode)this.nodeTable.get(bufferId);
        if (node != null) {
            return node;
        }
        DataBuffer buf = this.bufferMgr.getBuffer(bufferId);
        byte nodeType = NodeMgr.getNodeType(buf);
        switch (nodeType) {
            case 4: {
                node = new VarKeyRecordNode(this, buf);
                this.leafRecordCnt += node.keyCount;
                break;
            }
            case 3: {
                node = new VarKeyInteriorNode(this, buf);
                break;
            }
            default: {
                this.bufferMgr.releaseBuffer(buf);
                throw new AssertException("Unexpected Node Type (" + nodeType + ") found, expecting VarKeyNode");
            }
        }
        return node;
    }

    static byte getNodeType(DataBuffer buffer) {
        return buffer.getByte(0);
    }

    static void setNodeType(DataBuffer buffer, byte nodeType) {
        buffer.putByte(0, nodeType);
    }
}

