/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintAbstractDecompilerAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;

public class TaintLoadAction
extends TaintAbstractDecompilerAction {
    private TaintPlugin plugin;
    private static String loadSarifFileIconString = "icon.fsbrowser.file.extension.obj";
    private static Icon loadSarifFileIcon = new GIcon(loadSarifFileIconString);

    public TaintLoadAction(TaintPlugin plugin) {
        super("Load SARIF file");
        this.setHelpLocation(new HelpLocation("DecompilerTaint", "TaintLoadSarif"));
        this.setMenuBarData(new MenuData(new String[]{"Source-Sink", this.getName()}));
        this.setToolBarData(new ToolBarData(loadSarifFileIcon));
        this.plugin = plugin;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return true;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = context.getProgram();
        PluginTool tool = context.getTool();
        TaintState state = this.plugin.getTaintState();
        GhidraFileChooser file_chooser = new GhidraFileChooser((Component)tool.getToolFrame());
        file_chooser.setCurrentDirectory(new File(state.getOptions().getTaintEnginePath()));
        file_chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        file_chooser.setTitle("Select a Source-Sink Query Results SARIF File");
        File sarifFile = file_chooser.getSelectedFile(true);
        if (sarifFile != null && sarifFile.canRead()) {
            this.plugin.consoleMessage(String.format("Setting feature file: %s\n", sarifFile.getAbsolutePath()));
            state.loadTaintData(program, sarifFile);
            this.plugin.consoleMessage("external query results loaded.");
        } else {
            this.plugin.consoleMessage("No sarif file specified, or file does not exist.");
        }
    }
}

