/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BootstrapMethods
implements StructConverter {
    private short bootstrapMethodsReference;
    private short numberOfBootstrapArguments;
    private short[] bootstrapArguments;

    public BootstrapMethods(BinaryReader reader) throws IOException {
        this.bootstrapMethodsReference = reader.readNextShort();
        this.numberOfBootstrapArguments = reader.readNextShort();
        this.bootstrapArguments = reader.readNextShortArray(this.getNumberOfBootstrapArguments());
    }

    public int getBootstrapMethodsReference() {
        return this.bootstrapMethodsReference & 0xFFFF;
    }

    public int getNumberOfBootstrapArguments() {
        return this.numberOfBootstrapArguments & 0xFFFF;
    }

    public int getBootstrapArgumentsEntry(int i) {
        return this.bootstrapArguments[i] & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("bootstrap_methods", 0);
        structure.add(WORD, "bootstrap_method_ref", null);
        structure.add(WORD, "num_bootstrap_arguments", null);
        if (this.numberOfBootstrapArguments > 0) {
            ArrayDataType array = new ArrayDataType(WORD, (int)this.numberOfBootstrapArguments, WORD.getLength());
            structure.add((DataType)array, "bootstrapArguments", null);
        }
        return structure;
    }
}

