/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.annotproc;

import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annotproc.FormatVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ValidationContext {
    final Types typeUtils;
    final Elements elementUtils;
    final Messager messager;
    final TypeElement LIST_ELEM;
    final TypeElement DB_ANNOTATED_OBJECT_ELEM;
    final TypeElement DB_OBJECT_COLUMN_ELEM;
    final TypeElement DB_FIELD_CODEC_ELEM;
    final TypeElement DEFAULT_CODEC_ELEM;
    final TypeElement ENUM_ELEM;

    public ValidationContext(ProcessingEnvironment env) {
        this.typeUtils = env.getTypeUtils();
        this.elementUtils = env.getElementUtils();
        this.messager = env.getMessager();
        this.LIST_ELEM = this.elementUtils.getTypeElement(List.class.getCanonicalName());
        this.DB_ANNOTATED_OBJECT_ELEM = this.elementUtils.getTypeElement("ghidra.util.database.DBAnnotatedObject");
        this.DB_OBJECT_COLUMN_ELEM = this.elementUtils.getTypeElement("ghidra.util.database.DBObjectColumn");
        this.DB_FIELD_CODEC_ELEM = this.elementUtils.getTypeElement("ghidra.util.database.DBCachedObjectStoreFactory.DBFieldCodec");
        this.DEFAULT_CODEC_ELEM = this.elementUtils.getTypeElement(DBAnnotatedField.class.getCanonicalName() + ".DefaultCodec");
        this.ENUM_ELEM = this.elementUtils.getTypeElement(Enum.class.getCanonicalName());
    }

    public boolean isSubclass(TypeElement t1, TypeElement t2) {
        return this.typeUtils.isSubtype(this.typeUtils.erasure(t1.asType()), this.typeUtils.erasure(t2.asType()));
    }

    public boolean hasType(VariableElement field, TypeElement type) {
        return this.hasType(field, type.asType());
    }

    public boolean hasType(VariableElement field, TypeMirror type) {
        Map<String, TypeMirror> enumArgs;
        TypeMirror argE;
        DeclaredType declType;
        TypeMirror fieldType = field.asType();
        try {
            PrimitiveType unboxed = this.typeUtils.unboxedType(type);
            if (this.typeUtils.isSameType(fieldType, unboxed)) {
                return true;
            }
        }
        catch (IllegalArgumentException unboxed) {
            // empty catch block
        }
        if (fieldType.getKind() == TypeKind.DECLARED && this.isSubclass((TypeElement)(declType = (DeclaredType)fieldType).asElement(), this.ENUM_ELEM) && this.typeUtils.isSameType(declType, argE = (enumArgs = this.getArguments(declType, this.ENUM_ELEM)).get("E"))) {
            return true;
        }
        return this.typeUtils.isAssignable(fieldType, type);
    }

    public boolean isCapturable(TypeMirror t1, TypeMirror t2) {
        if (t2.getKind() == TypeKind.TYPEVAR) {
            TypeVariable v2 = (TypeVariable)t2;
            if (!this.typeUtils.isSubtype(t1, v2.getUpperBound())) {
                return false;
            }
            return this.typeUtils.isSubtype(v2.getLowerBound(), t1);
        }
        return this.typeUtils.isSubtype(t1, t2);
    }

    public boolean isEnumType(TypeMirror t) {
        if (t.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType enumType = this.typeUtils.getDeclaredType(this.ENUM_ELEM, t);
        return this.typeUtils.isSubtype(t, enumType);
    }

    protected DeclaredType findSupertype(Set<DeclaredType> types, TypeElement superType) {
        while (!types.isEmpty()) {
            HashSet<DeclaredType> next = new HashSet<DeclaredType>();
            for (DeclaredType t : types) {
                List<? extends TypeMirror> supers = this.typeUtils.directSupertypes(t);
                for (TypeMirror typeMirror : supers) {
                    DeclaredType ds = (DeclaredType)typeMirror;
                    if (superType == ds.asElement()) {
                        return ds;
                    }
                    next.add(ds);
                }
            }
            types = next;
        }
        return null;
    }

    public DeclaredType findSupertype(DeclaredType type, TypeElement superElem) {
        return this.findSupertype(Set.of(type), superElem);
    }

    public DeclaredType findSupertype(TypeElement elem, TypeElement superElem) {
        return this.findSupertype((DeclaredType)elem.asType(), superElem);
    }

    protected Map<String, TypeMirror> toArgsMap(TypeElement superElem, DeclaredType superType) {
        List<? extends TypeParameterElement> typeParameters = superElem.getTypeParameters();
        List<? extends TypeMirror> typeArguments = superType.getTypeArguments();
        assert (typeParameters.size() == typeArguments.size());
        HashMap<String, TypeMirror> result = new HashMap<String, TypeMirror>();
        for (int i = 0; i < typeParameters.size(); ++i) {
            result.put(typeParameters.get(i).getSimpleName().toString(), typeArguments.get(i));
        }
        return result;
    }

    public Map<String, TypeMirror> getArguments(DeclaredType type, TypeElement superElem) {
        return this.toArgsMap(superElem, this.findSupertype(type, superElem));
    }

    public Map<String, TypeMirror> getArguments(TypeElement elem, TypeElement superElem) {
        return this.toArgsMap(superElem, this.findSupertype(elem, superElem));
    }

    public String format(TypeMirror type) {
        FormatVisitor vis = new FormatVisitor();
        type.accept(vis, null);
        return vis.buf.toString();
    }
}

