/*
 * Decompiled with CFR 0.152.
 */
package ghidra.asm.wild.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyStateGenerator;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyContextGraph;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseBranch;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseTreeNode;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.asm.wild.grammars.WildAssemblyProduction;
import ghidra.asm.wild.sem.WildAssemblyConstructStateGenerator;
import ghidra.asm.wild.sem.WildAssemblyFixedNumericStateGenerator;
import ghidra.asm.wild.sem.WildAssemblyNopStateGenerator;
import ghidra.asm.wild.sem.WildAssemblyNumericMapStateGenerator;
import ghidra.asm.wild.sem.WildAssemblyNumericStateGenerator;
import ghidra.asm.wild.sem.WildAssemblyResolvedPatterns;
import ghidra.asm.wild.sem.WildAssemblyStringMapStateGenerator;
import ghidra.asm.wild.sem.WildAssemblyStringStateGenerator;
import ghidra.asm.wild.symbol.WildAssemblyFixedNumericTerminal;
import ghidra.asm.wild.symbol.WildAssemblyNumericMapTerminal;
import ghidra.asm.wild.symbol.WildAssemblyNumericTerminal;
import ghidra.asm.wild.symbol.WildAssemblyStringMapTerminal;
import ghidra.asm.wild.symbol.WildAssemblyStringTerminal;
import ghidra.asm.wild.symbol.WildAssemblySubtableTerminal;
import ghidra.asm.wild.tree.WildAssemblyParseHiddenNode;
import ghidra.asm.wild.tree.WildAssemblyParseToken;
import ghidra.program.model.address.Address;

public class WildAssemblyTreeResolver
extends AbstractAssemblyTreeResolver<WildAssemblyResolvedPatterns> {
    public WildAssemblyTreeResolver(AbstractAssemblyResolutionFactory<WildAssemblyResolvedPatterns, ?> factory, SleighLanguage lang, Address at, AssemblyParseBranch tree, AssemblyPatternBlock context, AssemblyContextGraph ctxGraph) {
        super(factory, lang, at, tree, context, ctxGraph);
    }

    protected AbstractAssemblyStateGenerator<?> getWildHiddenStateGenerator(OperandSymbol opSym, String wildcard, AssemblyResolvedPatterns fromLeft) {
        TripleSymbol defSym = opSym.getDefiningSymbol();
        if (defSym instanceof SubtableSymbol) {
            SubtableSymbol subtable = (SubtableSymbol)defSym;
            return new WildAssemblyConstructStateGenerator(this, subtable, wildcard, fromLeft);
        }
        return new WildAssemblyNopStateGenerator(this, null, opSym, wildcard, fromLeft);
    }

    protected AbstractAssemblyStateGenerator<?> getStateGenerator(OperandSymbol opSym, AssemblyParseTreeNode node, AssemblyResolvedPatterns fromLeft) {
        AssemblyParseBranch branch;
        if (node instanceof WildAssemblyParseHiddenNode) {
            WildAssemblyParseHiddenNode hidden = (WildAssemblyParseHiddenNode)node;
            return this.getWildHiddenStateGenerator(opSym, hidden.wildcard, fromLeft);
        }
        if (node instanceof AssemblyParseBranch && !(branch = (AssemblyParseBranch)node).isConstructor() && branch.getProduction() instanceof WildAssemblyProduction) {
            assert (branch.getSubstitutions().size() == 1);
            return this.getStateGenerator(opSym, branch.getSubstitution(0), fromLeft);
        }
        if (!(node instanceof WildAssemblyParseToken)) {
            return super.getStateGenerator(opSym, node, fromLeft);
        }
        WildAssemblyParseToken token = (WildAssemblyParseToken)node;
        AssemblySymbol assemblySymbol = node.getSym();
        if (assemblySymbol instanceof WildAssemblySubtableTerminal) {
            WildAssemblySubtableTerminal term = (WildAssemblySubtableTerminal)assemblySymbol;
            return this.getWildHiddenStateGenerator(opSym, token.wildcardName(), fromLeft);
        }
        assemblySymbol = node.getSym();
        if (assemblySymbol instanceof WildAssemblyNumericMapTerminal) {
            WildAssemblyNumericMapTerminal term = (WildAssemblyNumericMapTerminal)assemblySymbol;
            return new WildAssemblyNumericMapStateGenerator(this, token, opSym, term.map, fromLeft);
        }
        assemblySymbol = node.getSym();
        if (assemblySymbol instanceof WildAssemblyStringMapTerminal) {
            WildAssemblyStringMapTerminal term = (WildAssemblyStringMapTerminal)assemblySymbol;
            return new WildAssemblyStringMapStateGenerator(this, token, opSym, term.map, fromLeft);
        }
        assemblySymbol = node.getSym();
        if (assemblySymbol instanceof WildAssemblyStringTerminal) {
            WildAssemblyStringTerminal term = (WildAssemblyStringTerminal)assemblySymbol;
            return new WildAssemblyStringStateGenerator(this, token, opSym, term.str, fromLeft);
        }
        assemblySymbol = node.getSym();
        if (assemblySymbol instanceof WildAssemblyFixedNumericTerminal) {
            WildAssemblyFixedNumericTerminal term = (WildAssemblyFixedNumericTerminal)assemblySymbol;
            return new WildAssemblyFixedNumericStateGenerator(this, token, opSym, term.val, fromLeft);
        }
        assemblySymbol = node.getSym();
        if (assemblySymbol instanceof WildAssemblyNumericTerminal) {
            WildAssemblyNumericTerminal term = (WildAssemblyNumericTerminal)assemblySymbol;
            return new WildAssemblyNumericStateGenerator(this, token, opSym, token.wildcardName(), fromLeft);
        }
        return super.getStateGenerator(opSym, node, fromLeft);
    }
}

