---
stage: GitLab Delivery
group: Operate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Linuxチートシート
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

これは、GitLabサポートチームが収集したLinuxに関する情報であり、トラブルシューティングの際に使用することがあります。これは透明性のため、またLinuxの経験があるユーザーのためにここに記載されています。現在GitLabで問題が発生している場合は、この情報を利用する前に、まず[サポートオプション](https://about.gitlab.com/support/)を確認してください。

{{< alert type="warning" >}}

[システムの管理を支援することは、GitLabサポートの範囲外です](https://about.gitlab.com/support/statement-of-support/#training)。GitLabの管理者は、選択したディストリビューションに対応するこれらのコマンドを知っていることが想定されています。あなたがGitLabサポートエンジニアであるならば、これを`yum` -> `apt-get`などの変換のための相互参照として検討してください。

{{< /alert >}}

以下のコマンドのほとんどは、どのディストリビューションで動作するかを示すラベルが付けられていません。それらを追加するためのコントリビュートをお待ちしております。

## システムコマンド {#system-commands}

### ディストリビューション情報 {#distribution-information}

```shell
# Debian/Ubuntu
uname -a
lsb_release -a

# CentOS/RedHat
cat /etc/centos-release
cat /etc/redhat-release

# This will provide a lot more information
cat /etc/os-release
```

### シャットダウンまたは再起動 {#shut-down-or-reboot}

```shell
shutdown -h now
reboot
```

### 権限 {#permissions}

```shell
# change the user:group ownership of a file/dir
chown root:git <file_or_dir>

# make a file executable
chmod u+x <file>
```

### ファイルとディレクトリ {#files-and-directories}

```shell
# create a new directory and all subdirectories
mkdir -p dir/dir2/dir3

# Send a command's output to file.txt, no STDOUT
ls > file.txt

# Send a command's output to file.txt AND see it in STDOUT
ls | tee /tmp/file.txt

# Search and Replace within a file
sed -i 's/original-text/new-text/g' <filename>
```

### 設定されているすべての環境変数を表示する {#see-all-set-environment-variables}

```shell
env
```

## 検索 {#searching}

### ファイル名 {#filenames}

```shell
# search for a file in a filesystem
find . -name 'filename.rb' -print

# locate a file
locate <filename>

# see command history
history

# search CLI history
<Control>-R
```

### ファイルの内容 {#file-contents}

```shell
# -B/A = show 2 lines before/after search_term
grep -B 2 -A 2 search_term <filename>

# -<number> shows both before and after
grep -2 search_term <filename>

# Search on all files in directory (recursively)
grep -r search_term <directory>

# Grep namespace/project/name of a GitLab repository
grep 'fullpath' /var/opt/gitlab/git-data/repositories/@hashed/<repo hash>/.git/config

# search through *.gz files is the same except with zgrep
zgrep search_term <filename>

# Fast grep printing lines containing a string pattern
fgrep -R string_pattern <filename or directory>
```

### CLI {#cli}

```shell
# View command history
history

# Run last command that started with 'his' (3 letters min)
!his

# Search through command history
<Control>-R


# Execute last command with sudo
sudo !!
```

## リソースの管理 {#managing-resources}

### メモリ、ディスク、およびCPUの使用率 {#memory-disk--cpu-usage}

```shell
# disk space info. The '-h' gives the data in human-readable values
df -h

# size of each file/dir and its contents in the current dir
du -hd 1

# or alternative
du -h --max-depth=1

# find files greater than certain size(k, M, G) and list them in order
# get rid of the + for exact, - for less than
find / -type f -size +100M -print0 | xargs -0 du -hs | sort -h

# Find free memory on a system
free -m

# Find what processes are using memory/CPU and organize by it
# Load average is 1/CPU for 1, 5, and 15 minutes
top -o %MEM
top -o %CPU
```

### Strace {#strace}

```shell
# strace a process
strace -tt -T -f -y -yy -s 1024 -p <pid>

# -tt   print timestamps with microsecond accuracy

# -T    print the time spent in each syscall

# -f    also trace any child processes that forked

# -y    print the path associated with file handles

# -yy    print socket and device file handle details

# -s    max string length to print for an event

# -o    output file

# run strace on all puma processes
ps auwx | grep puma | awk '{ print " -p " $2}' | xargs strace -tt -T -f -y -yy -s 1024 -o /tmp/puma.txt
```

Straceは、実行中にシステムパフォーマンスに大きな影響を与える可能性があることに注意してください。

#### Straceリソース {#strace-resources}

- 簡単なウォークスルーについては、[strace zine](https://wizardzines.com/zines/strace/)を参照してください。
- Brendan Greggは、[straceの使用方法](http://www.brendangregg.com/blog/2014-05-11/strace-wow-much-syscall.html)についてより詳細な説明をしています。
- GitLabを理解するためにstraceを使用することに関する[一連のGitLab Unfilteredビデオ](https://www.youtube.com/playlist?list=PL05JrBw4t0KoC7cIkoAFcRhr4gsVesekg)があります。

### Strace Parserツール {#the-strace-parser-tool}

弊社の[strace-parser tool](https://gitlab.com/wchandler/strace-parser)を使用して、`strace`出力のハイレベルなサマリーを提供できます。これは`strace -C`に似ていますが、より詳細な統計を提供します。

MacOSとLinuxのバイナリ[が利用可能です](https://gitlab.com/gitlab-com/support/toolbox/strace-parser/-/tags)。または、Rustのコンパイラがある場合は、ソースからビルドできます。

#### ツールの使用方法 {#how-to-use-the-tool}

最初に`summary`フラグを指定してツールを実行し、タスクを積極的に実行するのに費やした時間でソートされた上位プロセスのサマリーを取得します。`-s`または`--sort`フラグを使用して、合計時間、システムコール数、PID #、および子プロセス数に基づいてソートすることもできます。結果の数はデフォルトで25プロセスですが、`-c`/`--count`オプションを使用して変更できます。詳細については、`--help`を参照してください。

```shell
$ ./strace-parser sidekiq_trace.txt summary -c15 -s=pid

Top 15 PIDs by PID #
-----------

  pid         actv (ms)     wait (ms)     user (ms)    total (ms)    % of actv     syscalls     children
  -------    ----------    ----------    ----------    ----------    ---------    ---------    ---------
  16706           0.000         0.000         0.000         0.000        0.00%            0            0
  16708           0.000         0.000         0.000         0.000        0.00%            0            0
  16716           0.000         0.000         0.000         0.000        0.00%            0            0
  16717           0.000         0.000         0.000         0.000        0.00%            0            0
  16718           0.000         0.000         0.000         0.000        0.00%            0            0
  16719           0.000         0.000         0.000         0.000        0.00%            0            0
  16720           0.389      9796.434         1.090      9797.912        0.02%           16            0
  16721           0.000         0.000         0.000         0.000        0.00%            0            0
  16722           0.000         0.000         0.000         0.000        0.00%            0            0
  16723           0.000         0.000         0.000         0.000        0.00%            0            0
  16804           0.218     11099.535         1.881     11101.634        0.01%           36            0
  16813           0.000         0.000         0.000         0.000        0.00%            0            0
  16814           1.740     11825.640         4.616     11831.996        0.10%           57            0
  16815           2.364     12039.993         7.669     12050.026        0.14%           80            0
  16816           0.000         0.000         0.000         0.000        0.00%            0            0

PIDs   93
real   0m12.287s
user   0m1.474s
sys    0m1.686s
```

サマリーに基づいて、特定のプロセスには`-p`/`--pid`、ソートされたリストには`-s`/`--stats`フラグを使用して、1つまたは複数のプロセスによって行われたシステムコールの詳細を表示できます。`--stats`は、サマリーと同じソートおよびカウントオプションを使用します。

```shell
./strace-parser sidekiq_trace.txt p 16815

PID 16815

  80 syscalls, active time: 2.364ms, user time: 7.669ms, total time: 12050.026ms
  start time: 22:46:14.830267    end time: 22:46:26.880293

  syscall                 count    total (ms)      max (ms)      avg (ms)      min (ms)    errors
  -----------------    --------    ----------    ----------    ----------    ----------    --------
  futex                       5     10100.229      5400.106      2020.046         0.022    ETIMEDOUT: 2
  restart_syscall             1      1939.764      1939.764      1939.764      1939.764    ETIMEDOUT: 1
  getpid                     33         1.020         0.046         0.031         0.018
  clock_gettime              14         0.420         0.038         0.030         0.021
  stat                        6         0.277         0.072         0.046         0.031
  read                        6         0.170         0.036         0.028         0.020
  openat                      3         0.126         0.045         0.042         0.038
  close                       3         0.099         0.034         0.033         0.031
  lseek                       3         0.089         0.035         0.030         0.021
  ioctl                       3         0.082         0.033         0.027         0.023    ENOTTY: 3
  fstat                       3         0.081         0.034         0.027         0.022
  ---------------

  Slowest file open times for PID 16815:

    dur (ms)       timestamp            error         filename
  ----------    ---------------    ---------------    ---------
       0.045    22:46:16.771318           -           /opt/gitlab/embedded/service/gitlab-rails/config/database.yml
       0.043    22:46:26.877954           -           /opt/gitlab/embedded/service/gitlab-rails/config/database.yml
       0.038    22:46:22.174610           -           /opt/gitlab/embedded/service/gitlab-rails/config/database.yml
```

前の例では、`PID 16815`のオープンに時間がかかったファイルを確認できます。

結果で何も目立たない場合、より多くのコンテキストを取得する良い方法は、顧客が行ったアクションを実行しながら、自分のGitLabインスタンスで`strace`を実行し、両方の結果のサマリーを比較して、違いを詳しく調べることです。

#### Openシステムコールの統計 {#stats-for-the-open-syscall}

さまざまな設定での`open`および`openat`（ファイルへのアクセスに使用）のコールの概算値。ストレージが遅いと、Gitalyで恐ろしい`DeadlineExceeded`エラーが発生する可能性があります。

ファイルシステムのパフォーマンスを確認するために顧客が実行できるクイックテストについては、[ハンドブックのこのエントリ](../operations/filesystem_benchmarking.md)を参照してください。

`strace`からのタイミング情報は多少不正確であることが多いため、小さな違いは重要視しないでください。

|セットアップ          | アクセス時間  |
|:--------------|:--------------|
| Amazon Elastic File System           | 10 - 30ミリ秒     |
| ローカルストレージ | 0.01 - 1ミリ秒    |

## ネットワーキング {#networking}

### ポート {#ports}

```shell
# Find the programs that are listening on ports
netstat -plnt
ss -plnt
lsof -i -P | grep <port>
```

### インターネット/ドメイン名サービス {#internetdns}

```shell
# Show domain IP address
dig +short example.com
nslookup example.com

# Check DNS using specific nameserver
# 8.8.8.8 = google, 1.1.1.1 = cloudflare, 208.67.222.222 = opendns
dig @8.8.8.8 example.com
nslookup example.com 1.1.1.1

# Find host provider
whois <ip_address> | grep -i "orgname\|netname"

# Curl headers with redirect
curl --head --location "https://example.com"

# Test if a host is reachable on the network. `ping6` works on IPv6 networks.
ping example.com

# Show the route taken to a host. `traceroute6` works on IPv6 networks.
traceroute example.com
mtr example.com

# List details of network interfaces
ip address

# Check local DNS settings
cat /etc/hosts
cat /etc/resolv.conf
systemd-resolve --status

# Capture traffic to/from a host
sudo tcpdump host www.example.com
```

## パッケージ管理 {#package-management}

```shell
# Debian/Ubuntu

# List packages
dpkg -l
apt list --installed

# Find an installed package
dpkg -l | grep <package>
apt list --installed | grep <package>

# Install a package
dpkg -i <package_name>.deb
apt-get install <package>
apt install <package>

# CentOS/RedHat

# Install a package
yum install <package>
dnf install <package> # RHEL/CentOS 8+

rpm -ivh <package_name>.rpm

# Find an installed package
rpm -qa | grep <package>
```

## ログ {#logs}

```shell
# Print last lines in log file where 'n'
# is the number of lines to print
tail -n /path/to/log/file
```
