---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Sensitive cookie without Secure attribute
---

## Description

The cookie was transmitted in a `Set-Cookie` response without the `Secure` attribute set.
To prevent sensitive cookie values being accidentally transmitted over clear-text HTTP,
declare cookies with the `Secure` attribute.

## Remediation

Most web application frameworks allow configuring how cookies are sent to user agents. Consult your framework's
documentation for more information on how to enable various security attributes when assigning cookies to clients.

If the application is assigning cookies via writing to the response headers directly, ensure all responses include
the `Secure` attribute. By enabling this protection, the application will no longer send sensitive cookies over
HTTP.

Example:

```http
Set-Cookie: {cookie_name}=<random secure value>; Secure
```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 614.1 | false | 614 | Passive | Low |

## Links

- [OWASP](https://owasp.org/www-community/controls/SecureCookieAttribute)
- [CWE](https://cwe.mitre.org/data/definitions/614.html)
- [Mozilla MDN](https://developer.mozilla.org/en-US/docs/Web/HTTP/Cookies#restrict_access_to_cookies)
