import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import Prism from 'prismjs';
import { textUtil } from '@grafana/data';
import { useTheme2 } from '@grafana/ui';

function RawQuery({ query, language, className }) {
  const theme = useTheme2();
  const styles = getStyles(theme);
  const highlighted = Prism.highlight(query, language.grammar, language.name);
  return /* @__PURE__ */ jsx(
    "div",
    {
      className: cx(styles.editorField, "prism-syntax-highlight", className),
      "aria-label": "selector",
      dangerouslySetInnerHTML: { __html: textUtil.sanitize(highlighted) }
    }
  );
}
const getStyles = (theme) => {
  return {
    editorField: css({
      fontFamily: theme.typography.fontFamilyMonospace,
      fontSize: theme.typography.bodySmall.fontSize
    })
  };
};

export { RawQuery };
//# sourceMappingURL=RawQuery.js.map
