/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.execution.serviceView.ConfigureServicesDialog;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.platform.execution.serviceView.ServiceViewActionProvider;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/execution/serviceView/OpenInToolWindowAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "isExclusionAllowed", "", "contributor", "Lcom/intellij/execution/services/ServiceViewContributor;", "project", "Lcom/intellij/openapi/project/Project;", "getContributor", "intellij.platform.execution.serviceView"})
public final class OpenInToolWindowAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ToolWindow toolWindow = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow != null && !Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"Services")) {
            e.getPresentation().setText(ExecutionBundle.message((String)"service.view.include.into.services.action.text", (Object[])new Object[0]));
        }
        Project project = e.getProject();
        ServiceViewContributor<?> contributor = this.getContributor(e);
        boolean enabled = project != null && contributor != null && this.isExclusionAllowed(contributor, project);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || !e.isFromContextMenu());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ToolWindow toolWindow = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow != null && !Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"Services")) {
            ServiceViewManager serviceViewManager = ServiceViewManager.getInstance((Project)project2);
            Intrinsics.checkNotNull((Object)serviceViewManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.serviceView.ServiceViewManagerImpl");
            ((ServiceViewManagerImpl)serviceViewManager).includeToolWindow(toolWindow.getId());
        } else {
            ServiceViewContributor<?> serviceViewContributor = this.getContributor(e);
            if (serviceViewContributor == null) {
                return;
            }
            ServiceViewContributor<?> contributor = serviceViewContributor;
            ArrayList excluded = new ArrayList((Collection)ConfigureServicesDialog.Companion.collectServices$intellij_platform_execution_serviceView(project2).getSecond());
            excluded.add(contributor);
            ServiceViewManager serviceViewManager = ServiceViewManager.getInstance((Project)project2);
            Intrinsics.checkNotNull((Object)serviceViewManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.serviceView.ServiceViewManagerImpl");
            ((ServiceViewManagerImpl)serviceViewManager).setExcludedContributors(excluded);
        }
    }

    private final boolean isExclusionAllowed(ServiceViewContributor<?> contributor, Project project) {
        ServiceViewDescriptor serviceViewDescriptor = contributor.getViewDescriptor(project);
        ServiceViewToolWindowDescriptor serviceViewToolWindowDescriptor = serviceViewDescriptor instanceof ServiceViewToolWindowDescriptor ? (ServiceViewToolWindowDescriptor)serviceViewDescriptor : null;
        return !(serviceViewToolWindowDescriptor != null ? !serviceViewToolWindowDescriptor.isExclusionAllowed() : false);
    }

    private final ServiceViewContributor<?> getContributor(AnActionEvent e) {
        List<ServiceModel.ServiceViewItem> list = ServiceViewActionProvider.getSelectedItems(e);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSelectedItems(...)");
        ServiceModel.ServiceViewItem serviceViewItem = (ServiceModel.ServiceViewItem)CollectionsKt.singleOrNull(list);
        return serviceViewItem != null ? serviceViewItem.getRootContributor() : null;
    }
}

