/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.search.AbstractSearchable;

public class TableSearchable
extends AbstractSearchable {
    protected JXTable table;

    public TableSearchable(JXTable table) {
        this.table = table;
    }

    @Override
    protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards2) {
        AbstractSearchable.SearchResult matchRow = null;
        if (backwards2) {
            for (int r2 = startRow; r2 >= -1 && matchRow == null; --r2) {
                matchRow = this.findMatchBackwardsInRow(pattern, r2);
                this.updateState(matchRow);
            }
        } else {
            for (int r3 = startRow; r3 <= this.getSize() && matchRow == null; ++r3) {
                matchRow = this.findMatchForwardInRow(pattern, r3);
                this.updateState(matchRow);
            }
        }
    }

    @Override
    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
        return this.findMatchAt(pattern, row, this.lastSearchResult.foundColumn);
    }

    private AbstractSearchable.SearchResult findMatchForwardInRow(Pattern pattern, int row) {
        int startColumn;
        int n = startColumn = this.lastSearchResult.foundColumn < 0 ? 0 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(row)) {
            for (int column2 = startColumn; column2 < this.table.getColumnCount(); ++column2) {
                AbstractSearchable.SearchResult result2 = this.findMatchAt(pattern, row, column2);
                if (result2 == null) continue;
                return result2;
            }
        }
        return null;
    }

    private AbstractSearchable.SearchResult findMatchBackwardsInRow(Pattern pattern, int row) {
        int startColumn;
        int n = startColumn = this.lastSearchResult.foundColumn < 0 ? this.table.getColumnCount() - 1 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(row)) {
            for (int column2 = startColumn; column2 >= 0; --column2) {
                AbstractSearchable.SearchResult result2 = this.findMatchAt(pattern, row, column2);
                if (result2 == null) continue;
                return result2;
            }
        }
        return null;
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row, int column2) {
        Matcher matcher;
        String text = this.table.getStringAt(row, column2);
        if (text != null && text.length() > 0 && (matcher = pattern.matcher(text)).find()) {
            return this.createSearchResult(matcher, row, column2);
        }
        return null;
    }

    @Override
    protected int adjustStartPosition(int startIndex, boolean backwards2) {
        this.lastSearchResult.foundColumn = -1;
        return super.adjustStartPosition(startIndex, backwards2);
    }

    @Override
    protected int moveStartPosition(int startRow, boolean backwards2) {
        if (backwards2) {
            --this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn < 0) {
                --startRow;
            }
        } else {
            ++this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn >= this.table.getColumnCount()) {
                this.lastSearchResult.foundColumn = -1;
                ++startRow;
            }
        }
        return startRow;
    }

    @Override
    protected boolean isEqualStartIndex(int startIndex) {
        return super.isEqualStartIndex(startIndex) && this.isValidColumn(this.lastSearchResult.foundColumn);
    }

    private boolean isValidColumn(int column2) {
        return column2 >= 0 && column2 < this.table.getColumnCount();
    }

    @Override
    protected int getSize() {
        return this.table.getRowCount();
    }

    @Override
    public JXTable getTarget() {
        return this.table;
    }

    protected void moveMatchByHighlighter() {
        AbstractHighlighter searchHL = this.getConfiguredMatchHighlighter();
        if (!this.hasMatch()) {
            return;
        }
        this.ensureInsertedSearchHighlighters(searchHL);
        this.table.scrollCellToVisible(this.lastSearchResult.foundRow, this.lastSearchResult.foundColumn);
    }

    @Override
    protected int convertColumnIndexToModel(int viewColumn) {
        return this.getTarget().convertColumnIndexToModel(viewColumn);
    }

    protected void moveMatchBySelection() {
        Rectangle cellRect;
        if (!this.hasMatch()) {
            return;
        }
        int row = this.lastSearchResult.foundRow;
        int column2 = this.lastSearchResult.foundColumn;
        this.table.changeSelection(row, column2, false, false);
        if (!this.table.getAutoscrolls() && (cellRect = this.table.getCellRect(row, column2, true)) != null) {
            this.table.scrollRectToVisible(cellRect);
        }
    }

    @Override
    protected void moveMatchMarker() {
        if (this.markByHighlighter()) {
            this.moveMatchByHighlighter();
        } else {
            this.moveMatchBySelection();
        }
    }

    @Override
    protected void removeHighlighter(Highlighter searchHighlighter) {
        this.table.removeHighlighter(searchHighlighter);
    }

    @Override
    protected Highlighter[] getHighlighters() {
        return this.table.getHighlighters();
    }

    @Override
    protected void addHighlighter(Highlighter highlighter) {
        this.table.addHighlighter(highlighter);
    }
}

