/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection.naming;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.siyeh.InspectionGadgetsBundle;
import org.jetbrains.annotations.NonNls;

public final class TestClassNamingConvention
extends NamingConvention<PsiClass> {
    private static final int DEFAULT_MIN_LENGTH = 5;
    private static final int DEFAULT_MAX_LENGTH = 255;
    @NonNls
    public static final String TEST_CLASS_NAMING_CONVENTION_SHORT_NAME = "JUnitTestClassNamingConvention";

    public NamingConventionBean createDefaultBean() {
        return new NamingConventionBean("[A-Z][A-Za-z\\d]*Test(s|Case)?|Test[A-Z][A-Za-z\\d]*|IT(.*)|(.*)IT(Case)?", 5, 255, new String[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean isApplicable(PsiClass member) {
        if (member instanceof PsiTypeParameter) {
            return false;
        }
        if (!member.hasModifierProperty("static") && member.getContainingClass() != null) {
            return false;
        }
        TestFramework framework = TestFrameworks.detectFramework((PsiClass)member);
        return framework instanceof JavaTestFramework && framework.isTestClass((PsiElement)member) && !((JavaTestFramework)framework).isSuiteClass(member);
    }

    public String getShortName() {
        return TEST_CLASS_NAMING_CONVENTION_SHORT_NAME;
    }

    public String getElementDescription() {
        return InspectionGadgetsBundle.message((String)"junit.test.class.naming.convention.element.description", (Object[])new Object[0]);
    }
}

