/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.util.ByRef;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ClusterProviderFactory;
import org.keycloak.cluster.infinispan.LockEntry;
import org.keycloak.cluster.infinispan.remote.RemoteInfinispanClusterProvider;
import org.keycloak.cluster.infinispan.remote.RemoteInfinispanNotificationManager;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class RemoteInfinispanClusterProviderFactory
implements ClusterProviderFactory,
RemoteInfinispanClusterProvider.SharedData,
EnvironmentDependentProviderFactory {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private volatile RemoteCache<String, LockEntry> workCache;
    private volatile int clusterStartupTime;
    private volatile RemoteInfinispanNotificationManager notificationManager;
    private volatile Executor executor;

    public ClusterProvider create(KeycloakSession session) {
        if (this.workCache == null) {
            this.lazyInit(session);
        }
        assert (this.workCache != null);
        assert (this.notificationManager != null);
        assert (this.executor != null);
        return new RemoteInfinispanClusterProvider(this);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            this.lazyInit(session);
        }
    }

    public synchronized void close() {
        logger.debug((Object)"Closing provider");
        if (this.notificationManager != null) {
            this.notificationManager.removeClientListener();
            this.notificationManager = null;
        }
        this.executor = null;
        this.workCache = null;
    }

    public String getId() {
        return "remote";
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isRemoteInfinispan();
    }

    private synchronized void lazyInit(KeycloakSession session) {
        if (this.workCache != null) {
            return;
        }
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.executor = provider.getExecutor("cluster-provider");
        this.clusterStartupTime = RemoteInfinispanClusterProviderFactory.initClusterStartupTime(provider.getRemoteCache("work"), (int)(session.getKeycloakSessionFactory().getServerStartupTimestamp() / 1000L));
        this.notificationManager = new RemoteInfinispanNotificationManager(this.executor, provider.getRemoteCache("work"), provider.getNodeInfo());
        this.notificationManager.addClientListener();
        this.workCache = provider.getRemoteCache("work");
        logger.debugf("Provider initialized. Cluster startup time: %s", (Object)Time.toDate((int)this.clusterStartupTime));
    }

    private static int initClusterStartupTime(RemoteCache<String, Integer> cache, int serverStartupTime) {
        Integer clusterStartupTime = RemoteInfinispanClusterProviderFactory.putIfAbsentWithRetries(cache, "cluster-start-time", serverStartupTime, -1);
        return clusterStartupTime == null ? serverStartupTime : clusterStartupTime;
    }

    static <V> V putIfAbsentWithRetries(RemoteCache<String, V> workCache, String key, V value, int taskTimeoutInSeconds) {
        ByRef ref = new ByRef(null);
        Retry.executeWithBackoff(iteration -> {
            try {
                if (taskTimeoutInSeconds > 0) {
                    ref.set(workCache.putIfAbsent((Object)key, value, (long)taskTimeoutInSeconds, TimeUnit.SECONDS));
                } else {
                    ref.set(workCache.putIfAbsent((Object)key, value));
                }
            }
            catch (HotRodClientException re) {
                logger.warnf((Throwable)re, "Failed to write key '%s' and value '%s' in iteration '%d' . Retrying", (Object)key, value, (Object)iteration);
                throw re;
            }
        }, (int)10, (int)10);
        return (V)ref.get();
    }

    @Override
    public int clusterStartupTime() {
        return this.clusterStartupTime;
    }

    @Override
    public RemoteCache<String, LockEntry> cache() {
        return this.workCache;
    }

    @Override
    public RemoteInfinispanNotificationManager notificationManager() {
        return this.notificationManager;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }
}

