/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor;
import com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery;
import com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader;
import java.io.IOException;
import java.util.Vector;

public class RecoveryManagerImple {
    private PeriodicRecovery _periodicRecovery = null;
    private RecActivatorLoader _recActivatorLoader = null;

    public RecoveryManagerImple(boolean threaded) {
        boolean useListener = recoveryPropertyManager.getRecoveryEnvironmentBean().isRecoveryListener();
        if (useListener && this.isRecoveryManagerEndPointInUse()) {
            try {
                tsLogger.i18NLogger.fatal_recovery_fail(RecoveryManager.getRecoveryManagerHost().getHostAddress(), Integer.toString(RecoveryManager.getRecoveryManagerPort()));
            }
            catch (Throwable t) {
                tsLogger.i18NLogger.fatal_recovery_fail("unknown", "unknown");
            }
            throw new FatalError("Recovery manager already active (or recovery port and address are in use)!");
        }
        this._recActivatorLoader = new RecActivatorLoader();
        this._recActivatorLoader.startRecoveryActivators();
        this._periodicRecovery = new PeriodicRecovery(threaded, useListener);
        ExpiredEntryMonitor.startUp();
        try {
            if (tsLogger.logger.isInfoEnabled()) {
                if (useListener) {
                    tsLogger.i18NLogger.info_recovery_socketready(Integer.toString(this._periodicRecovery.getServerSocket().getLocalPort()));
                } else {
                    tsLogger.logger.debug((Object)"RecoveryManagerImple is ready. Socket listener is turned off.");
                }
            }
        }
        catch (IOException ex) {
            tsLogger.i18NLogger.warn_recovery_RecoveryManagerImple_2(ex);
        }
    }

    public final void scan() {
        this._periodicRecovery.doWork();
    }

    public final void addModule(RecoveryModule module) {
        this._periodicRecovery.addModule(module);
    }

    public final void removeModule(RecoveryModule module, boolean waitOnScan) {
        this._periodicRecovery.removeModule(module, waitOnScan);
    }

    public final void removeAllModules(boolean waitOnScan) {
        this._periodicRecovery.removeAllModules(waitOnScan);
    }

    public final Vector<RecoveryModule> getModules() {
        return this._periodicRecovery.getModules();
    }

    public void start() {
        if (!this._periodicRecovery.isAlive()) {
            this._periodicRecovery.start();
        }
    }

    public void stop(boolean async) {
        ExpiredEntryMonitor.shutdown();
        this._periodicRecovery.shutdown(async);
    }

    public PeriodicRecovery.Mode trySuspendScan(boolean async, boolean waitForWorkLeftToDo) {
        return this._periodicRecovery.suspendScan(async, waitForWorkLeftToDo);
    }

    public PeriodicRecovery.Mode trySuspendScan(boolean async) {
        return this.trySuspendScan(async, false);
    }

    public void resumeScan() {
        this._periodicRecovery.resumeScan();
    }

    public void waitForTermination() {
        try {
            this._periodicRecovery.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean isRecoveryManagerEndPointInUse() {
        if (this._periodicRecovery != null) {
            return this._periodicRecovery.getMode() != PeriodicRecovery.Mode.TERMINATED;
        }
        return false;
    }
}

