/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing.channels;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.StreamingRestChannel;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.channels.TraceableStreamingRestChannel;

public class TraceableRestChannel<T extends RestChannel>
implements RestChannel {
    protected final T delegate;
    protected final Span span;
    protected final Tracer tracer;

    protected TraceableRestChannel(T delegate, Span span, Tracer tracer) {
        this.span = Objects.requireNonNull(span);
        this.delegate = (RestChannel)Objects.requireNonNull(delegate);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public static RestChannel create(RestChannel delegate, Span span, Tracer tracer) {
        if (tracer.isRecording()) {
            if (delegate instanceof StreamingRestChannel) {
                StreamingRestChannel streamingRestChannel = (StreamingRestChannel)delegate;
                return new TraceableStreamingRestChannel(streamingRestChannel, span, tracer);
            }
            return new TraceableRestChannel<RestChannel>(delegate, span, tracer);
        }
        return delegate;
    }

    @Override
    public XContentBuilder newBuilder() throws IOException {
        return this.delegate.newBuilder();
    }

    @Override
    public XContentBuilder newErrorBuilder() throws IOException {
        return this.delegate.newErrorBuilder();
    }

    @Override
    public XContentBuilder newBuilder(MediaType mediaType, boolean useFiltering) throws IOException {
        return this.delegate.newBuilder(mediaType, useFiltering);
    }

    @Override
    public XContentBuilder newBuilder(MediaType mediaType, MediaType responseContentType, boolean useFiltering) throws IOException {
        return this.delegate.newBuilder(mediaType, responseContentType, useFiltering);
    }

    @Override
    public BytesStreamOutput bytesOutput() {
        return this.delegate.bytesOutput();
    }

    @Override
    public RestRequest request() {
        return this.delegate.request();
    }

    @Override
    public boolean detailedErrorsEnabled() {
        return this.delegate.detailedErrorsEnabled();
    }

    @Override
    public boolean detailedErrorStackTraceEnabled() {
        return this.delegate.detailedErrorStackTraceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(RestResponse response) {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.sendResponse(response);
        }
        finally {
            this.span.endSpan();
        }
    }
}

