/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.GetSnapshotsResult;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.SnapshotManagementException;
import org.opensearch.indexmanagement.snapshotmanagement.UpdateNextExecutionTimeResult;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.SMResult;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMMetadata;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotMissingException;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.ClusterAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00b2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0086@\u00a2\u0006\u0002\u0010\u000e\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0086@\u00a2\u0006\u0002\u0010\u000e\u001a\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a<\u0010\u0018\u001a\u00020\u0019*\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010!\u001a\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u000b\u001a\u000e\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020%\u001a\u0018\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\b\b\u0002\u0010*\u001a\u00020+\u001a\u0010\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020\u0004\u001a\u0010\u0010-\u001a\u00020\u00042\b\u0010.\u001a\u0004\u0018\u00010\u0004\u001a.\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000201002\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000201002\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020504*\b\u0012\u0004\u0012\u000205042\u0006\u0010\u0005\u001a\u00020\u0004\u001a(\u00106\u001a\b\u0012\u0004\u0012\u00020504*\u00020\f2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004H\u0086@\u00a2\u0006\u0002\u00109\u001aD\u00106\u001a\u00020:*\u00020\f2\u0006\u0010;\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u00042\u0006\u0010<\u001a\u00020=2\u0006\u0010\u0000\u001a\u00020\u00012\b\u0010>\u001a\u0004\u0018\u00010\u00042\u0006\u0010?\u001a\u00020\u0004H\u0086@\u00a2\u0006\u0002\u0010@\u001a.\u0010A\u001a\u00020B2\u0006\u0010<\u001a\u00020=2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010I\u001a\u00020J2\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0014\u0010K\u001a\u00020 *\u00020L2\b\u0010M\u001a\u0004\u0018\u00010D\u001a&\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020L2\u0006\u0010<\u001a\u00020=2\u0006\u0010Q\u001a\u00020H2\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0016\u0010R\u001a\u00020\u00042\u0006\u0010P\u001a\u00020L2\u0006\u0010Q\u001a\u00020H\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020%X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "smPolicyNameToDocId", "", "policyName", "smDocIdToPolicyName", "docId", "smPolicyNameToMetadataDocId", "smMetadataDocIdToPolicyName", "getSMPolicy", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;", "Lorg/opensearch/transport/client/Client;", "policyID", "(Lorg/opensearch/transport/client/Client;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSMMetadata", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata;", "jobID", "parseSMPolicy", "response", "Lorg/opensearch/action/get/GetResponse;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "parseSMMetadata", "indexMetadata", "Lorg/opensearch/action/index/IndexResponse;", "metadata", "id", "seqNo", "", "primaryTerm", "create", "", "(Lorg/opensearch/transport/client/Client;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata;Ljava/lang/String;JJZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateSnapshotName", "policy", "RANDOM_STRING_LENGTH", "", "getRandomString", "length", "generateFormatDate", "dateFormat", "timezone", "Ljava/time/ZoneId;", "validateDateFormat", "preFixTimeStamp", "msg", "addSMPolicyInSnapshotMetadata", "", "", "snapshotConfig", "filterBySMPolicyInSnapshotMetadata", "", "Lorg/opensearch/snapshots/SnapshotInfo;", "getSnapshots", "name", "repo", "(Lorg/opensearch/transport/client/Client;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/opensearch/indexmanagement/snapshotmanagement/GetSnapshotsResult;", "job", "metadataBuilder", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Builder;", "snapshotMissingMsg", "exceptionMsg", "(Lorg/opensearch/transport/client/Client;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;Ljava/lang/String;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Builder;Lorg/apache/logging/log4j/Logger;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryUpdatingNextExecutionTime", "Lorg/opensearch/indexmanagement/snapshotmanagement/UpdateNextExecutionTimeResult;", "nextTime", "Ljava/time/Instant;", "schedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "workflowType", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/WorkflowType;", "validateSMPolicyName", "", "isExceed", "Lorg/opensearch/common/unit/TimeValue;", "startTime", "timeLimitExceeded", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMResult;", "timeLimit", "workflow", "getTimeLimitExceededMessage", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nSMUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMUtils.kt\norg/opensearch/indexmanagement/snapshotmanagement/SMUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,387:1\n1#2:388\n774#3:389\n865#3,2:390\n1563#3:392\n1634#3,3:393\n1563#3:400\n1634#3,3:401\n774#3:404\n865#3:405\n1761#3,3:406\n866#3:409\n37#4:396\n36#4,3:397\n*S KotlinDebug\n*F\n+ 1 SMUtils.kt\norg/opensearch/indexmanagement/snapshotmanagement/SMUtilsKt\n*L\n210#1:389\n210#1:390,2\n220#1:392\n220#1:393,3\n266#1:400\n266#1:401,3\n269#1:404\n269#1:405\n270#1:406,3\n269#1:409\n220#1:396\n220#1:397,3\n*E\n"})
public final class SMUtilsKt {
    private static final Logger log = LogManager.getLogger((String)"o.i.s.SnapshotManagementHelper");
    public static final int RANDOM_STRING_LENGTH = 8;

    @NotNull
    public static final String smPolicyNameToDocId(@NotNull String policyName) {
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        return policyName + "-sm-policy";
    }

    @NotNull
    public static final String smDocIdToPolicyName(@NotNull String docId) {
        Intrinsics.checkNotNullParameter((Object)docId, (String)"docId");
        return StringsKt.substringBeforeLast$default((String)docId, (String)"-sm-policy", null, (int)2, null);
    }

    @NotNull
    public static final String smPolicyNameToMetadataDocId(@NotNull String policyName) {
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        return policyName + "-sm-metadata";
    }

    @NotNull
    public static final String smMetadataDocIdToPolicyName(@NotNull String docId) {
        Intrinsics.checkNotNullParameter((Object)docId, (String)"docId");
        return StringsKt.substringBeforeLast$default((String)docId, (String)"-sm-metadata", null, (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getSMPolicy(@NotNull Client $this$getSMPolicy, @NotNull String policyID, @NotNull Continuation<? super SMPolicy> $completion) {
        if (!($completion instanceof getSMPolicy.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SMUtilsKt.getSMPolicy(null, null, (Continuation<? super SMPolicy>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                getRequest = new GetRequest(".opendistro-ism-config", policyID);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getSMPolicy);
                $continuation.L$1 = policyID;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)getRequest);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$getSMPolicy, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getSMPolicy$lambda$0(org.opensearch.action.get.GetRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((GetRequest)getRequest), $continuation);
                ** if (v0 != var7_5) goto lbl22
lbl21:
                // 1 sources

                return var7_5;
lbl22:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                getRequest = (GetRequest)$continuation.L$2;
                policyID = (String)$continuation.L$1;
                $this$getSMPolicy = (Client)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    if (!(getResponse = (GetResponse)v0).isExists() || getResponse.isSourceEmpty()) {
                        throw new OpenSearchStatusException("Snapshot management policy not found", RestStatus.NOT_FOUND, new Object[0]);
                    }
                    return SMUtilsKt.parseSMPolicy$default(getResponse, null, 2, null);
                }
                catch (OpenSearchStatusException e) {
                    throw e;
                }
                catch (IndexNotFoundException e) {
                    throw new OpenSearchStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management policy [" + policyID + "]", (Throwable)e);
                    throw new OpenSearchStatusException("Snapshot management policy could not be parsed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                catch (Exception e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management policy [" + policyID + "]", (Throwable)e);
                    throw new OpenSearchStatusException("Failed to retrieve Snapshot management policy.", RestStatus.NOT_FOUND, new Object[0]);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getSMMetadata(@NotNull Client $this$getSMMetadata, @NotNull String jobID, @NotNull Continuation<? super SMMetadata> $completion) {
        if (!($completion instanceof getSMMetadata.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SMUtilsKt.getSMMetadata(null, null, (Continuation<? super SMMetadata>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                metadataID = SMUtilsKt.smPolicyNameToMetadataDocId(SMUtilsKt.smDocIdToPolicyName(jobID));
                getRequest = new GetRequest(".opendistro-ism-config", metadataID).routing(jobID);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getSMMetadata);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)jobID);
                $continuation.L$2 = metadataID;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)getRequest);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$getSMMetadata, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getSMMetadata$lambda$1(org.opensearch.action.get.GetRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((GetRequest)getRequest), $continuation);
                ** if (v0 != var8_5) goto lbl24
lbl23:
                // 1 sources

                return var8_5;
lbl24:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                getRequest = (GetRequest)$continuation.L$3;
                metadataID = (String)$continuation.L$2;
                jobID = (String)$continuation.L$1;
                $this$getSMMetadata = (Client)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    if (!(getResponse = (GetResponse)v0).isExists() || getResponse.isSourceEmpty()) {
                        return null;
                    }
                    return SMUtilsKt.parseSMMetadata$default(getResponse, null, 2, null);
                }
                catch (OpenSearchStatusException e) {
                    throw e;
                }
                catch (IndexNotFoundException e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management metadata [" + metadataID + "] because config index did not exist", (Throwable)e);
                    throw new OpenSearchStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management metadata [" + metadataID + "]", (Throwable)e);
                    throw new OpenSearchStatusException("Snapshot management metadata could not be parsed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                catch (Exception e) {
                    SMUtilsKt.log.error("Failed to retrieve snapshot management metadata [" + metadataID + "]", (Throwable)e);
                    throw new OpenSearchStatusException("Failed to retrieve Snapshot management metadata.", RestStatus.NOT_FOUND, new Object[0]);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final SMPolicy parseSMPolicy(@NotNull GetResponse response2, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
        Intrinsics.checkNotNull((Object)xcp);
        String string = response2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return (SMPolicy)OpenSearchExtensionsKt.parseWithType(xcp, string, response2.getSeqNo(), response2.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, SMPolicy>((Object)SMPolicy.Companion){

            public final SMPolicy invoke(XContentParser p0, String p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((SMPolicy.Companion)this.receiver).parse(p0, p1, p2, p3);
            }
        });
    }

    public static /* synthetic */ SMPolicy parseSMPolicy$default(GetResponse getResponse, NamedXContentRegistry namedXContentRegistry, int n, Object object) {
        if ((n & 2) != 0) {
            NamedXContentRegistry namedXContentRegistry2 = NamedXContentRegistry.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)namedXContentRegistry2, (String)"EMPTY");
            namedXContentRegistry = namedXContentRegistry2;
        }
        return SMUtilsKt.parseSMPolicy(getResponse, namedXContentRegistry);
    }

    @NotNull
    public static final SMMetadata parseSMMetadata(@NotNull GetResponse response2, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
        Intrinsics.checkNotNull((Object)xcp);
        String string = response2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return (SMMetadata)OpenSearchExtensionsKt.parseWithType(xcp, string, response2.getSeqNo(), response2.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, SMMetadata>((Object)SMMetadata.Companion){

            public final SMMetadata invoke(XContentParser p0, String p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((SMMetadata.Companion)this.receiver).parse(p0, p1, p2, p3);
            }
        });
    }

    public static /* synthetic */ SMMetadata parseSMMetadata$default(GetResponse getResponse, NamedXContentRegistry namedXContentRegistry, int n, Object object) {
        if ((n & 2) != 0) {
            NamedXContentRegistry namedXContentRegistry2 = NamedXContentRegistry.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)namedXContentRegistry2, (String)"EMPTY");
            namedXContentRegistry = namedXContentRegistry2;
        }
        return SMUtilsKt.parseSMMetadata(getResponse, namedXContentRegistry);
    }

    @Nullable
    public static final Object indexMetadata(@NotNull Client $this$indexMetadata, @NotNull SMMetadata metadata2, @NotNull String id, long seqNo, long primaryTerm, boolean create, @NotNull Continuation<? super IndexResponse> $completion) {
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").create(create).id(SMUtilsKt.smPolicyNameToMetadataDocId(SMUtilsKt.smDocIdToPolicyName(id)));
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
        IndexRequest indexReq = indexRequest.source(metadata2.toXContent(xContentBuilder, params)).setIfSeqNo(seqNo).setIfPrimaryTerm(primaryTerm).routing(id);
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$indexMetadata, (arg_0, arg_1) -> SMUtilsKt.indexMetadata$lambda$2(indexReq, arg_0, arg_1), $completion);
    }

    public static /* synthetic */ Object indexMetadata$default(Client client, SMMetadata sMMetadata, String string, long l, long l2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return SMUtilsKt.indexMetadata(client, sMMetadata, string, l, l2, bl, (Continuation<? super IndexResponse>)continuation);
    }

    @NotNull
    public static final String generateSnapshotName(@NotNull SMPolicy policy2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)policy2, (String)"policy");
        Object result2 = policy2.getPolicyName();
        String dateFormat = (String)policy2.getSnapshotConfig().get("date_format");
        if (dateFormat == null) {
            dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
        }
        if (policy2.getSnapshotConfig().get("date_format_timezone") != null) {
            Object object = policy2.getSnapshotConfig().get("date_format_timezone");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            ZoneId zoneId = ZoneId.of((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(...)");
            string = SMUtilsKt.generateFormatDate(dateFormat, zoneId);
        } else {
            string = SMUtilsKt.generateFormatDate$default(dateFormat, null, 2, null);
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String dateValue = string2;
        result2 = (String)result2 + "-" + dateValue;
        return (String)result2 + "-" + SMUtilsKt.getRandomString(8);
    }

    @NotNull
    public static final String getRandomString(int length) {
        List allowedChars = CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('0', '9')));
        ArrayList<Character> arrayList = new ArrayList<Character>(length);
        int n = 0;
        while (n < length) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Character> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(Character.valueOf(((Character)CollectionsKt.random((Collection)allowedChars, (Random)((Random)Random.Default))).charValue()));
        }
        return CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String generateFormatDate(@NotNull String dateFormat, @NotNull ZoneId timezone) {
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        DateFormatter dateFormatter = DateFormatter.forPattern((String)dateFormat).withZone(timezone);
        String string = dateFormatter.format((TemporalAccessor)Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static /* synthetic */ String generateFormatDate$default(String string, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.of("UTC");
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"of(...)");
            zoneId = zoneId2;
        }
        return SMUtilsKt.generateFormatDate(string, zoneId);
    }

    @Nullable
    public static final String validateDateFormat(@NotNull String dateFormat) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        try {
            ZoneId timeZone = ZoneId.systemDefault();
            DateFormatter dateFormatter = DateFormatter.forPattern((String)dateFormat).withZone(timeZone);
            Instant instant = dateFormatter.toDateMathParser().parse("now/s", System::currentTimeMillis, false, timeZone);
            dateFormatter.format((TemporalAccessor)instant);
            string = null;
        }
        catch (Exception e) {
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "Invalid date format.";
            }
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String preFixTimeStamp(@Nullable String msg) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT;
        return "[" + formatter.format(Instant.now().truncatedTo(ChronoUnit.SECONDS)) + "]: " + msg;
    }

    @NotNull
    public static final Map<String, Object> addSMPolicyInSnapshotMetadata(@NotNull Map<String, ? extends Object> snapshotConfig, @NotNull String policyName) {
        Intrinsics.checkNotNullParameter(snapshotConfig, (String)"snapshotConfig");
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        Map snapshotMetadata = TypeIntrinsics.asMutableMap((Object)snapshotConfig.get("metadata"));
        if (snapshotMetadata != null) {
            snapshotMetadata.put("sm_policy", policyName);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"sm_policy", (Object)policyName)};
            snapshotMetadata = MapsKt.mutableMapOf((Pair[])pairArray);
        }
        Map snapshotConfigWithSMPolicyMetadata = MapsKt.toMutableMap(snapshotConfig);
        snapshotConfigWithSMPolicyMetadata.put("metadata", snapshotMetadata);
        return snapshotConfigWithSMPolicyMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SnapshotInfo> filterBySMPolicyInSnapshotMetadata(@NotNull List<SnapshotInfo> $this$filterBySMPolicyInSnapshotMetadata, @NotNull String policyName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterBySMPolicyInSnapshotMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        Iterable $this$filter$iv = $this$filterBySMPolicyInSnapshotMetadata;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SnapshotInfo it = (SnapshotInfo)element$iv$iv;
            boolean bl = false;
            Map map = it.userMetadata();
            if (!Intrinsics.areEqual(map != null ? map.get("sm_policy") : null, (Object)policyName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getSnapshots(@NotNull Client $this$getSnapshots, @NotNull String name, @NotNull String repo, @NotNull Continuation<? super List<SnapshotInfo>> $completion) {
        if (!($completion instanceof getSnapshots.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SMUtilsKt.getSnapshots(null, null, null, (Continuation<? super List<SnapshotInfo>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new String[]{","};
                $this$map$iv = StringsKt.split$default((CharSequence)name, (String[])var5_7, (boolean)false, (int)0, (int)6, null);
                $i$f$map = false;
                var7_13 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var12_18 = (String)item$iv$iv;
                    var14_20 = destination$iv$iv;
                    $i$a$-map-SMUtilsKt$getSnapshots$patterns$1 = false;
                    var14_20.add(StringsKt.trim((CharSequence)((CharSequence)it)).toString());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                patterns = thisCollection$iv.toArray(new String[0]);
                req = new GetSnapshotsRequest().snapshots(patterns).repository(repo);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getSnapshots);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)name);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)repo);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)patterns);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)req);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$getSnapshots.admin().cluster(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getSnapshots$lambda$6(org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest org.opensearch.transport.client.ClusterAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/ClusterAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((GetSnapshotsRequest)req), $continuation);
                ** if (v0 != var17_6) goto lbl43
lbl42:
                // 1 sources

                return var17_6;
lbl43:
                // 1 sources

                ** GOTO lbl54
            }
            case 1: {
                req = (GetSnapshotsRequest)$continuation.L$4;
                patterns = (String[])$continuation.L$3;
                repo = (String)$continuation.L$2;
                name = (String)$continuation.L$1;
                $this$getSnapshots = (Client)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl54:
                    // 2 sources

                    res = (GetSnapshotsResponse)v0;
                    v1 = res.getSnapshots();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getSnapshots(...)");
                    return v1;
                }
                catch (RemoteTransportException ex) {
                    v2 = ExceptionsHelper.unwrapCause((Throwable)ex);
                    Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type java.lang.Exception");
                    unwrappedException = (Exception)v2;
                    throw unwrappedException;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getSnapshots(@NotNull Client $this$getSnapshots, @NotNull SMPolicy job, @NotNull String name, @NotNull SMMetadata.Builder metadataBuilder, @NotNull Logger log, @Nullable String snapshotMissingMsg, @NotNull String exceptionMsg, @NotNull Continuation<? super GetSnapshotsResult> $completion) {
        if (!($completion instanceof getSnapshots.2)) ** GOTO lbl-1000
        var29_8 = $completion;
        if ((var29_8.label & -2147483648) != 0) {
            var29_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SMUtilsKt.getSnapshots(null, null, null, null, null, null, null, (Continuation<? super GetSnapshotsResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var30_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = job.getSnapshotConfig().get("repository");
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type kotlin.String");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getSnapshots);
                $continuation.L$1 = job;
                $continuation.L$2 = name;
                $continuation.L$3 = metadataBuilder;
                $continuation.L$4 = log;
                $continuation.L$5 = snapshotMissingMsg;
                $continuation.L$6 = exceptionMsg;
                $continuation.label = 1;
                v1 = SMUtilsKt.getSnapshots($this$getSnapshots, name, (String)v0, (Continuation<? super List<SnapshotInfo>>)$continuation);
                ** if (v1 != var30_10) goto lbl27
lbl26:
                // 1 sources

                return var30_10;
lbl27:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                exceptionMsg = (String)$continuation.L$6;
                snapshotMissingMsg = (String)$continuation.L$5;
                log = (Logger)$continuation.L$4;
                metadataBuilder = (SMMetadata.Builder)$continuation.L$3;
                name = (String)$continuation.L$2;
                job = (SMPolicy)$continuation.L$1;
                $this$getSnapshots = (Client)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl40:
                    // 2 sources

                    var9_11 = (List)v1;
                }
                catch (SnapshotMissingException ex) {
                    v2 = snapshotMissingMsg;
                    if (v2 != null) {
                        it = v2;
                        $i$a$-let-SMUtilsKt$getSnapshots$snapshots$1 = false;
                        log.warn(snapshotMissingMsg);
                    }
                    return new GetSnapshotsResult(false, CollectionsKt.emptyList(), metadataBuilder);
                }
                catch (Exception ex) {
                    log.error(exceptionMsg, (Throwable)ex);
                    SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.RETRYING, false, exceptionMsg, false, ex, null, 42, null);
                    return new GetSnapshotsResult(true, CollectionsKt.emptyList(), metadataBuilder);
                }
                snapshots = var9_11;
                ex = new String[]{","};
                $this$map$iv = StringsKt.split$default((CharSequence)name, (String[])ex, (boolean)false, (int)0, (int)6, null);
                $i$f$map = false;
                it = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var17_28 = (String)item$iv$iv;
                    var27_31 = destination$iv$iv;
                    $i$a$-map-SMUtilsKt$getSnapshots$patterns$2 = false;
                    var27_31.add(StringsKt.trim((CharSequence)((CharSequence)it)).toString());
                }
                patterns = (List)destination$iv$iv;
                policyNamePattern = job.getPolicyName() + "*";
                $this$filter$iv = snapshots;
                $i$f$filter = false;
                $i$f$mapTo = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (E element$iv$iv : $this$filterTo$iv$iv) {
                    snapshot = (SnapshotInfo)element$iv$iv;
                    $i$a$-filter-SMUtilsKt$getSnapshots$otherPatternSnapshots$1 = false;
                    $this$any$iv = patterns;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl84
                    v3 = false;
                    ** GOTO lbl92
lbl84:
                    // 2 sources

                    for (T element$iv : $this$any$iv) {
                        pattern = (String)element$iv;
                        $i$a$-any-SMUtilsKt$getSnapshots$otherPatternSnapshots$1$1 = false;
                        if (!(Intrinsics.areEqual((Object)pattern, (Object)policyNamePattern) == false && Regex.simpleMatch((String)pattern, (String)snapshot.snapshotId().getName()) != false)) continue;
                        v3 = true;
                        ** GOTO lbl92
                    }
                    v3 = false;
lbl92:
                    // 3 sources

                    if (!v3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                otherPatternSnapshots = (List)destination$iv$iv;
                policySnapshots = SMUtilsKt.filterBySMPolicyInSnapshotMetadata(snapshots, job.getPolicyName());
                snapshots = CollectionsKt.plus((Collection)policySnapshots, (Iterable)otherPatternSnapshots);
                return new GetSnapshotsResult(false, snapshots, metadataBuilder);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final UpdateNextExecutionTimeResult tryUpdatingNextExecutionTime(@NotNull SMMetadata.Builder metadataBuilder, @NotNull Instant nextTime, @NotNull Schedule schedule, @NotNull WorkflowType workflowType, @NotNull Logger log) {
        UpdateNextExecutionTimeResult updateNextExecutionTimeResult;
        Intrinsics.checkNotNullParameter((Object)metadataBuilder, (String)"metadataBuilder");
        Intrinsics.checkNotNullParameter((Object)nextTime, (String)"nextTime");
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        Intrinsics.checkNotNullParameter((Object)((Object)workflowType), (String)"workflowType");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Instant now = Instant.now();
        if (!now.isBefore(nextTime)) {
            log.info("Current time [" + Instant.now() + "] has passed nextExecutionTime [" + nextTime + "].");
            Instant newNextTime = schedule.getNextExecutionTime(now);
            switch (WhenMappings.$EnumSwitchMapping$0[workflowType.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)newNextTime);
                    SMMetadata.Builder builder = metadataBuilder.setNextCreationTime(newNextTime);
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)newNextTime);
                    SMMetadata.Builder builder = metadataBuilder.setNextDeletionTime(newNextTime);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            updateNextExecutionTimeResult = new UpdateNextExecutionTimeResult(true, metadataBuilder);
        } else {
            log.debug("Current time [" + Instant.now() + "] has not passed nextExecutionTime [" + nextTime + "]");
            updateNextExecutionTimeResult = new UpdateNextExecutionTimeResult(false, metadataBuilder);
        }
        return updateNextExecutionTimeResult;
    }

    public static final void validateSMPolicyName(@NotNull String policyName) {
        Intrinsics.checkNotNullParameter((Object)policyName, (String)"policyName");
        List errorMessages = new ArrayList();
        if (((CharSequence)policyName).length() == 0) {
            errorMessages.add("Policy name cannot be empty.");
        }
        if (StringsKt.contains$default((CharSequence)policyName, (CharSequence)" ", (boolean)false, (int)2, null)) {
            errorMessages.add("Policy name must not contain whitespace.");
        }
        if (StringsKt.contains$default((CharSequence)policyName, (CharSequence)",", (boolean)false, (int)2, null)) {
            errorMessages.add("Policy name must not contain ','.");
        }
        if (StringsKt.contains$default((CharSequence)policyName, (CharSequence)"#", (boolean)false, (int)2, null)) {
            errorMessages.add("Policy name must not contain '#'.");
        }
        if (StringsKt.startsWith$default((String)policyName, (String)"_", (boolean)false, (int)2, null)) {
            errorMessages.add("Policy name must not start with '_'.");
        }
        String string = policyName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string2, (Object)policyName)) {
            errorMessages.add("Policy name must be lowercase.");
        }
        if (!Strings.validFileName((String)policyName)) {
            errorMessages.add("Policy name must not contain the following characters " + Strings.INVALID_FILENAME_CHARS + ".");
        }
        if (!((Collection)errorMessages).isEmpty()) {
            throw new IllegalArgumentException(CollectionsKt.joinToString$default((Iterable)errorMessages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
    }

    public static final boolean isExceed(@NotNull TimeValue $this$isExceed, @Nullable Instant startTime) {
        Intrinsics.checkNotNullParameter((Object)$this$isExceed, (String)"<this>");
        if (startTime == null) {
            return false;
        }
        return Instant.now().toEpochMilli() - startTime.toEpochMilli() > $this$isExceed.getMillis();
    }

    @NotNull
    public static final SMResult timeLimitExceeded(@NotNull TimeValue timeLimit, @NotNull SMMetadata.Builder metadataBuilder, @NotNull WorkflowType workflow, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
        Intrinsics.checkNotNullParameter((Object)metadataBuilder, (String)"metadataBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)workflow), (String)"workflow");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        String message = SMUtilsKt.getTimeLimitExceededMessage(timeLimit, workflow);
        log.warn(message);
        SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.TIME_LIMIT_EXCEEDED, false, null, false, (Exception)((Object)new SnapshotManagementException(null, null, message, 3, null)), Instant.now(), 14, null);
        return new SMResult.Fail(metadataBuilder, workflow, true);
    }

    @NotNull
    public static final String getTimeLimitExceededMessage(@NotNull TimeValue timeLimit, @NotNull WorkflowType workflow) {
        Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
        Intrinsics.checkNotNullParameter((Object)((Object)workflow), (String)"workflow");
        String workflowStr = switch (WhenMappings.$EnumSwitchMapping$0[workflow.ordinal()]) {
            case 1 -> "creation";
            case 2 -> "deletion";
            default -> throw new NoWhenBranchMatchedException();
        };
        return "Time limit " + timeLimit + " exceeded during snapshot " + workflowStr + " step";
    }

    private static final Unit getSMPolicy$lambda$0(GetRequest $getRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.get($getRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit getSMMetadata$lambda$1(GetRequest $getRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.get($getRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit indexMetadata$lambda$2(IndexRequest $indexReq, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.index($indexReq, it);
        return Unit.INSTANCE;
    }

    private static final Unit getSnapshots$lambda$6(GetSnapshotsRequest $req, ClusterAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.getSnapshots($req, it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorkflowType.values().length];
            try {
                nArray[WorkflowType.CREATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkflowType.DELETION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

