/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.util;

import java.io.Serializable;
import java.util.Arrays;
import org.tribuo.math.util.VectorNormalizer;
import org.tribuo.util.onnx.ONNXNode;
import org.tribuo.util.onnx.ONNXOperators;

public class SigmoidNormalizer
implements VectorNormalizer,
Serializable {
    private static final long serialVersionUID = 1L;

    public static double sigmoid(double input) {
        return 1.0 / (1.0 + Math.exp(-input));
    }

    @Override
    public double[] normalize(double[] input) {
        double[] output = Arrays.copyOf(input, input.length);
        this.normalizeInPlace(output);
        return output;
    }

    @Override
    public void normalizeInPlace(double[] input) {
        for (int i = 0; i < input.length; ++i) {
            input[i] = SigmoidNormalizer.sigmoid(input[i]);
        }
    }

    @Override
    public ONNXNode exportNormalizer(ONNXNode input) {
        return input.apply(ONNXOperators.SIGMOID);
    }
}

