/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.memory;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.ml.common.MLMemoryType;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.common.memory.Memory;
import org.opensearch.ml.common.memory.Message;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.engine.memory.ConversationIndexMessage;
import org.opensearch.ml.engine.memory.MLMemoryManager;
import org.opensearch.ml.memory.action.conversation.CreateConversationResponse;
import org.opensearch.ml.memory.action.conversation.CreateInteractionResponse;
import org.opensearch.transport.client.Client;

public class ConversationIndexMemory
implements Memory<Message, CreateInteractionResponse, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(ConversationIndexMemory.class);
    public static final String TYPE = MLMemoryType.CONVERSATION_INDEX.name();
    public static final String CONVERSATION_ID = "conversation_id";
    public static final String FINAL_ANSWER = "final_answer";
    public static final String CREATED_TIME = "created_time";
    public static final String MEMORY_NAME = "memory_name";
    public static final String MEMORY_ID = "memory_id";
    public static final String APP_TYPE = "app_type";
    public static int LAST_N_INTERACTIONS = 10;
    protected String memoryMetaIndexName;
    protected String memoryMessageIndexName;
    protected String conversationId;
    protected boolean retrieveFinalAnswer = true;
    protected final Client client;
    private final MLIndicesHandler mlIndicesHandler;
    private MLMemoryManager memoryManager;

    public ConversationIndexMemory(Client client, MLIndicesHandler mlIndicesHandler, String memoryMetaIndexName, String memoryMessageIndexName, String conversationId, MLMemoryManager memoryManager) {
        this.client = client;
        this.mlIndicesHandler = mlIndicesHandler;
        this.memoryMetaIndexName = memoryMetaIndexName;
        this.memoryMessageIndexName = memoryMessageIndexName;
        this.conversationId = conversationId;
        this.memoryManager = memoryManager;
    }

    public String getType() {
        return TYPE;
    }

    public String getId() {
        return this.conversationId;
    }

    public void save(Message message, String parentId, Integer traceNum, String action) {
        this.save(message, parentId, traceNum, action, (ActionListener<CreateInteractionResponse>)ActionListener.wrap(r -> log.info("saved message into memory {}, parent id: {}, trace number: {}, interaction id: {}", (Object)this.conversationId, (Object)parentId, (Object)traceNum, (Object)r.getId()), e -> log.error("Failed to save interaction", (Throwable)e)));
    }

    public void save(Message message, String parentId, Integer traceNum, String action, ActionListener<CreateInteractionResponse> listener) {
        ConversationIndexMessage msg = (ConversationIndexMessage)message;
        this.memoryManager.createInteraction(this.conversationId, msg.getQuestion(), null, msg.getResponse(), action, null, parentId, traceNum, listener);
    }

    public void getMessages(int size, ActionListener listener) {
        this.memoryManager.getFinalInteractions(this.conversationId, size, (ActionListener<List<Interaction>>)listener);
    }

    public void clear() {
        throw new RuntimeException("clear method is not supported in ConversationIndexMemory");
    }

    public void update(String messageId, Map<String, Object> updateContent, ActionListener<UpdateResponse> updateListener) {
        this.getMemoryManager().updateInteraction(messageId, updateContent, updateListener);
    }

    public void deleteInteractionAndTrace(String interactionId, ActionListener<Boolean> listener) {
        this.memoryManager.deleteInteractionAndTrace(interactionId, listener);
    }

    @Generated
    public String getMemoryMetaIndexName() {
        return this.memoryMetaIndexName;
    }

    @Generated
    public String getMemoryMessageIndexName() {
        return this.memoryMessageIndexName;
    }

    @Generated
    public String getConversationId() {
        return this.conversationId;
    }

    @Generated
    public boolean isRetrieveFinalAnswer() {
        return this.retrieveFinalAnswer;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public MLIndicesHandler getMlIndicesHandler() {
        return this.mlIndicesHandler;
    }

    @Generated
    public MLMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public static class Factory
    implements Memory.Factory<ConversationIndexMemory> {
        private Client client;
        private MLIndicesHandler mlIndicesHandler;
        private String memoryMetaIndexName = ".plugins-ml-memory-meta";
        private String memoryMessageIndexName = ".plugins-ml-memory-message";
        private MLMemoryManager memoryManager;

        public void init(Client client, MLIndicesHandler mlIndicesHandler, MLMemoryManager memoryManager) {
            this.client = client;
            this.mlIndicesHandler = mlIndicesHandler;
            this.memoryManager = memoryManager;
        }

        public void create(Map<String, Object> map, ActionListener<ConversationIndexMemory> listener) {
            if (map == null || map.isEmpty()) {
                listener.onFailure((Exception)new IllegalArgumentException("Invalid input parameter for creating ConversationIndexMemory"));
                return;
            }
            String memoryId = (String)map.get(ConversationIndexMemory.MEMORY_ID);
            String name = (String)map.get(ConversationIndexMemory.MEMORY_NAME);
            String appType = (String)map.get(ConversationIndexMemory.APP_TYPE);
            this.create(name, memoryId, appType, listener);
        }

        private void create(String name, String memoryId, String appType, ActionListener<ConversationIndexMemory> listener) {
            if (Strings.isEmpty((CharSequence)memoryId)) {
                this.memoryManager.createConversation(name, appType, (ActionListener<CreateConversationResponse>)ActionListener.wrap(r -> {
                    this.create(r.getId(), listener);
                    log.debug("Created conversation on memory layer, conversation id: {}", (Object)r.getId());
                }, e -> {
                    log.error("Failed to save interaction", (Throwable)e);
                    listener.onFailure(e);
                }));
            } else {
                this.create(memoryId, listener);
            }
        }

        private void create(String memoryId, ActionListener<ConversationIndexMemory> listener) {
            listener.onResponse((Object)new ConversationIndexMemory(this.client, this.mlIndicesHandler, this.memoryMetaIndexName, this.memoryMessageIndexName, memoryId, this.memoryManager));
        }
    }
}

