/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.RSAEngine;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.params.RsaKeyParameters;
import org.bouncycastle.crypto.internal.params.RsaPrivateCrtKeyParameters;
import org.bouncycastle.util.BigIntegers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class RsaBlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private final RSAEngine core;
    private RsaKeyParameters key;
    private SecureRandom random;

    RsaBlindedEngine(RSAEngine rSAEngine) {
        this.core = rSAEngine;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.core.init(bl, cipherParameters);
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.key = (RsaKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            this.key = (RsaKeyParameters)cipherParameters;
            if (this.key.isPrivate()) {
                throw new IllegalArgumentException("No random provided where one required.");
            }
        }
    }

    @Override
    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n, int n2) {
        BigInteger bigInteger;
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger bigInteger2 = this.core.convertInput(byArray, n, n2);
        if (bigInteger2.compareTo(this.key.getModulus()) >= 0) {
            throw new DataLengthException("input to RSA engine out of range");
        }
        if (this.key instanceof RsaPrivateCrtKeyParameters) {
            RsaPrivateCrtKeyParameters rsaPrivateCrtKeyParameters = (RsaPrivateCrtKeyParameters)this.key;
            BigInteger bigInteger3 = rsaPrivateCrtKeyParameters.getPublicExponent();
            if (bigInteger3 != null) {
                BigInteger bigInteger4;
                BigInteger bigInteger5 = rsaPrivateCrtKeyParameters.getModulus();
                BigInteger bigInteger6 = BigIntegers.createRandomInRange(ONE, bigInteger5.subtract(ONE), this.random);
                BigInteger bigInteger7 = bigInteger6.modPow(bigInteger3, bigInteger5).multiply(bigInteger2).mod(bigInteger5);
                BigInteger bigInteger8 = this.core.processBlock(bigInteger7);
                bigInteger = bigInteger8.multiply(bigInteger4 = BigIntegers.modOddInverse(bigInteger5, bigInteger6)).mod(bigInteger5);
                if (!bigInteger2.equals(bigInteger.modPow(bigInteger3, bigInteger5))) {
                    throw new IllegalStateException("RSA engine faulty decryption/signing detected");
                }
            } else {
                bigInteger = this.core.processBlock(bigInteger2);
            }
        } else {
            bigInteger = this.core.processBlock(bigInteger2);
        }
        return this.core.convertOutput(bigInteger);
    }
}

