/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.DBECommitmentPolicy;
import software.amazon.cryptography.materialproviders.model.ESDKCommitmentPolicy;

public class CommitmentPolicy {
    private final ESDKCommitmentPolicy ESDK;
    private final DBECommitmentPolicy DBE;

    protected CommitmentPolicy(BuilderImpl builder) {
        this.ESDK = builder.ESDK();
        this.DBE = builder.DBE();
    }

    public ESDKCommitmentPolicy ESDK() {
        return this.ESDK;
    }

    public DBECommitmentPolicy DBE() {
        return this.DBE;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ESDKCommitmentPolicy ESDK;
        protected DBECommitmentPolicy DBE;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CommitmentPolicy model) {
            this.ESDK = model.ESDK();
            this.DBE = model.DBE();
        }

        @Override
        public Builder ESDK(ESDKCommitmentPolicy ESDK) {
            this.ESDK = ESDK;
            return this;
        }

        @Override
        public ESDKCommitmentPolicy ESDK() {
            return this.ESDK;
        }

        @Override
        public Builder DBE(DBECommitmentPolicy DBE) {
            this.DBE = DBE;
            return this;
        }

        @Override
        public DBECommitmentPolicy DBE() {
            return this.DBE;
        }

        @Override
        public CommitmentPolicy build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`CommitmentPolicy` is a Union. A Union MUST have one and only one value set.");
            }
            return new CommitmentPolicy(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.ESDK, this.DBE};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder ESDK(ESDKCommitmentPolicy var1);

        public ESDKCommitmentPolicy ESDK();

        public Builder DBE(DBECommitmentPolicy var1);

        public DBECommitmentPolicy DBE();

        public CommitmentPolicy build();
    }
}

