/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest.simulate;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ActionStatusOptions;
import org.opensearch.client.opensearch.ingest.simulate.DocumentSimulation;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PipelineSimulation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PipelineSimulation> {
    @Nullable
    private final DocumentSimulation doc;
    @Nonnull
    private final List<PipelineSimulation> processorResults;
    @Nullable
    private final String processorType;
    @Nullable
    private final ActionStatusOptions status;
    @Nullable
    private final String tag;
    public static final JsonpDeserializer<PipelineSimulation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineSimulation::setupPipelineSimulationDeserializer);

    private PipelineSimulation(Builder builder) {
        this.doc = builder.doc;
        this.processorResults = ApiTypeHelper.unmodifiable(builder.processorResults);
        this.processorType = builder.processorType;
        this.status = builder.status;
        this.tag = builder.tag;
    }

    public static PipelineSimulation of(Function<Builder, ObjectBuilder<PipelineSimulation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DocumentSimulation doc() {
        return this.doc;
    }

    @Nonnull
    public final List<PipelineSimulation> processorResults() {
        return this.processorResults;
    }

    @Nullable
    public final String processorType() {
        return this.processorType;
    }

    @Nullable
    public final ActionStatusOptions status() {
        return this.status;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.processorResults)) {
            generator.writeKey("processor_results");
            generator.writeStartArray();
            for (PipelineSimulation item0 : this.processorResults) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.processorType != null) {
            generator.writeKey("processor_type");
            generator.write(this.processorType);
        }
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPipelineSimulationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::doc, DocumentSimulation._DESERIALIZER, "doc");
        op.add(Builder::processorResults, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "processor_results");
        op.add(Builder::processorType, JsonpDeserializer.stringDeserializer(), "processor_type");
        op.add(Builder::status, ActionStatusOptions._DESERIALIZER, "status");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.doc);
        result = 31 * result + Objects.hashCode(this.processorResults);
        result = 31 * result + Objects.hashCode(this.processorType);
        result = 31 * result + Objects.hashCode(this.status);
        result = 31 * result + Objects.hashCode(this.tag);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineSimulation other = (PipelineSimulation)o;
        return Objects.equals(this.doc, other.doc) && Objects.equals(this.processorResults, other.processorResults) && Objects.equals(this.processorType, other.processorType) && Objects.equals(this.status, other.status) && Objects.equals(this.tag, other.tag);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, PipelineSimulation> {
        @Nullable
        private DocumentSimulation doc;
        @Nullable
        private List<PipelineSimulation> processorResults;
        @Nullable
        private String processorType;
        @Nullable
        private ActionStatusOptions status;
        @Nullable
        private String tag;

        public Builder() {
        }

        private Builder(PipelineSimulation o) {
            this.doc = o.doc;
            this.processorResults = Builder._listCopy(o.processorResults);
            this.processorType = o.processorType;
            this.status = o.status;
            this.tag = o.tag;
        }

        private Builder(Builder o) {
            this.doc = o.doc;
            this.processorResults = Builder._listCopy(o.processorResults);
            this.processorType = o.processorType;
            this.status = o.status;
            this.tag = o.tag;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder doc(@Nullable DocumentSimulation value) {
            this.doc = value;
            return this;
        }

        @Nonnull
        public final Builder doc(Function<DocumentSimulation.Builder, ObjectBuilder<DocumentSimulation>> fn) {
            return this.doc(fn.apply(new DocumentSimulation.Builder()).build());
        }

        @Nonnull
        public final Builder processorResults(List<PipelineSimulation> list) {
            this.processorResults = Builder._listAddAll(this.processorResults, list);
            return this;
        }

        @Nonnull
        public final Builder processorResults(PipelineSimulation value, PipelineSimulation ... values) {
            this.processorResults = Builder._listAdd(this.processorResults, value, values);
            return this;
        }

        @Nonnull
        public final Builder processorResults(Function<Builder, ObjectBuilder<PipelineSimulation>> fn) {
            return this.processorResults(fn.apply(new Builder()).build(), new PipelineSimulation[0]);
        }

        @Nonnull
        public final Builder processorType(@Nullable String value) {
            this.processorType = value;
            return this;
        }

        @Nonnull
        public final Builder status(@Nullable ActionStatusOptions value) {
            this.status = value;
            return this;
        }

        @Nonnull
        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        @Override
        @Nonnull
        public PipelineSimulation build() {
            this._checkSingleUse();
            return new PipelineSimulation(this);
        }
    }
}

