/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

public class ParentContextLookup<StartContext extends BaseContext, ParentContext extends BaseContext>
implements ContextDataLookupFunction<StartContext, ParentContext> {
    @Nonnull
    private final Class<ParentContext> parentType;

    public ParentContextLookup(@Nonnull @ParameterName(name="type") Class<ParentContext> type) {
        this.parentType = Constraint.isNotNull(type, "Parent context type cannot be null");
    }

    @Override
    @Nullable
    public ParentContext apply(@Nullable StartContext input) {
        BaseContext parent;
        if (input != null && this.parentType.isInstance(parent = ((BaseContext)input).getParent())) {
            return (ParentContext)((BaseContext)this.parentType.cast(parent));
        }
        return null;
    }
}

