//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appplatform/armappplatform/v2"
	"net/http"
	"net/url"
	"regexp"
)

// BuildServiceServer is a fake server for instances of the armappplatform.BuildServiceClient type.
type BuildServiceServer struct {
	// CreateOrUpdateBuild is the fake for method BuildServiceClient.CreateOrUpdateBuild
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateBuild func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildParam armappplatform.Build, options *armappplatform.BuildServiceClientCreateOrUpdateBuildOptions) (resp azfake.Responder[armappplatform.BuildServiceClientCreateOrUpdateBuildResponse], errResp azfake.ErrorResponder)

	// GetBuild is the fake for method BuildServiceClient.GetBuild
	// HTTP status codes to indicate success: http.StatusOK
	GetBuild func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *armappplatform.BuildServiceClientGetBuildOptions) (resp azfake.Responder[armappplatform.BuildServiceClientGetBuildResponse], errResp azfake.ErrorResponder)

	// GetBuildResult is the fake for method BuildServiceClient.GetBuildResult
	// HTTP status codes to indicate success: http.StatusOK
	GetBuildResult func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *armappplatform.BuildServiceClientGetBuildResultOptions) (resp azfake.Responder[armappplatform.BuildServiceClientGetBuildResultResponse], errResp azfake.ErrorResponder)

	// GetBuildResultLog is the fake for method BuildServiceClient.GetBuildResultLog
	// HTTP status codes to indicate success: http.StatusOK
	GetBuildResultLog func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *armappplatform.BuildServiceClientGetBuildResultLogOptions) (resp azfake.Responder[armappplatform.BuildServiceClientGetBuildResultLogResponse], errResp azfake.ErrorResponder)

	// GetBuildService is the fake for method BuildServiceClient.GetBuildService
	// HTTP status codes to indicate success: http.StatusOK
	GetBuildService func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *armappplatform.BuildServiceClientGetBuildServiceOptions) (resp azfake.Responder[armappplatform.BuildServiceClientGetBuildServiceResponse], errResp azfake.ErrorResponder)

	// GetResourceUploadURL is the fake for method BuildServiceClient.GetResourceUploadURL
	// HTTP status codes to indicate success: http.StatusOK
	GetResourceUploadURL func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *armappplatform.BuildServiceClientGetResourceUploadURLOptions) (resp azfake.Responder[armappplatform.BuildServiceClientGetResourceUploadURLResponse], errResp azfake.ErrorResponder)

	// GetSupportedBuildpack is the fake for method BuildServiceClient.GetSupportedBuildpack
	// HTTP status codes to indicate success: http.StatusOK
	GetSupportedBuildpack func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildpackName string, options *armappplatform.BuildServiceClientGetSupportedBuildpackOptions) (resp azfake.Responder[armappplatform.BuildServiceClientGetSupportedBuildpackResponse], errResp azfake.ErrorResponder)

	// GetSupportedStack is the fake for method BuildServiceClient.GetSupportedStack
	// HTTP status codes to indicate success: http.StatusOK
	GetSupportedStack func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, stackName string, options *armappplatform.BuildServiceClientGetSupportedStackOptions) (resp azfake.Responder[armappplatform.BuildServiceClientGetSupportedStackResponse], errResp azfake.ErrorResponder)

	// NewListBuildResultsPager is the fake for method BuildServiceClient.NewListBuildResultsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBuildResultsPager func(resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *armappplatform.BuildServiceClientListBuildResultsOptions) (resp azfake.PagerResponder[armappplatform.BuildServiceClientListBuildResultsResponse])

	// NewListBuildServicesPager is the fake for method BuildServiceClient.NewListBuildServicesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBuildServicesPager func(resourceGroupName string, serviceName string, options *armappplatform.BuildServiceClientListBuildServicesOptions) (resp azfake.PagerResponder[armappplatform.BuildServiceClientListBuildServicesResponse])

	// NewListBuildsPager is the fake for method BuildServiceClient.NewListBuildsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBuildsPager func(resourceGroupName string, serviceName string, buildServiceName string, options *armappplatform.BuildServiceClientListBuildsOptions) (resp azfake.PagerResponder[armappplatform.BuildServiceClientListBuildsResponse])

	// ListSupportedBuildpacks is the fake for method BuildServiceClient.ListSupportedBuildpacks
	// HTTP status codes to indicate success: http.StatusOK
	ListSupportedBuildpacks func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *armappplatform.BuildServiceClientListSupportedBuildpacksOptions) (resp azfake.Responder[armappplatform.BuildServiceClientListSupportedBuildpacksResponse], errResp azfake.ErrorResponder)

	// ListSupportedStacks is the fake for method BuildServiceClient.ListSupportedStacks
	// HTTP status codes to indicate success: http.StatusOK
	ListSupportedStacks func(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *armappplatform.BuildServiceClientListSupportedStacksOptions) (resp azfake.Responder[armappplatform.BuildServiceClientListSupportedStacksResponse], errResp azfake.ErrorResponder)
}

// NewBuildServiceServerTransport creates a new instance of BuildServiceServerTransport with the provided implementation.
// The returned BuildServiceServerTransport instance is connected to an instance of armappplatform.BuildServiceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBuildServiceServerTransport(srv *BuildServiceServer) *BuildServiceServerTransport {
	return &BuildServiceServerTransport{
		srv:                       srv,
		newListBuildResultsPager:  newTracker[azfake.PagerResponder[armappplatform.BuildServiceClientListBuildResultsResponse]](),
		newListBuildServicesPager: newTracker[azfake.PagerResponder[armappplatform.BuildServiceClientListBuildServicesResponse]](),
		newListBuildsPager:        newTracker[azfake.PagerResponder[armappplatform.BuildServiceClientListBuildsResponse]](),
	}
}

// BuildServiceServerTransport connects instances of armappplatform.BuildServiceClient to instances of BuildServiceServer.
// Don't use this type directly, use NewBuildServiceServerTransport instead.
type BuildServiceServerTransport struct {
	srv                       *BuildServiceServer
	newListBuildResultsPager  *tracker[azfake.PagerResponder[armappplatform.BuildServiceClientListBuildResultsResponse]]
	newListBuildServicesPager *tracker[azfake.PagerResponder[armappplatform.BuildServiceClientListBuildServicesResponse]]
	newListBuildsPager        *tracker[azfake.PagerResponder[armappplatform.BuildServiceClientListBuildsResponse]]
}

// Do implements the policy.Transporter interface for BuildServiceServerTransport.
func (b *BuildServiceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BuildServiceClient.CreateOrUpdateBuild":
		resp, err = b.dispatchCreateOrUpdateBuild(req)
	case "BuildServiceClient.GetBuild":
		resp, err = b.dispatchGetBuild(req)
	case "BuildServiceClient.GetBuildResult":
		resp, err = b.dispatchGetBuildResult(req)
	case "BuildServiceClient.GetBuildResultLog":
		resp, err = b.dispatchGetBuildResultLog(req)
	case "BuildServiceClient.GetBuildService":
		resp, err = b.dispatchGetBuildService(req)
	case "BuildServiceClient.GetResourceUploadURL":
		resp, err = b.dispatchGetResourceUploadURL(req)
	case "BuildServiceClient.GetSupportedBuildpack":
		resp, err = b.dispatchGetSupportedBuildpack(req)
	case "BuildServiceClient.GetSupportedStack":
		resp, err = b.dispatchGetSupportedStack(req)
	case "BuildServiceClient.NewListBuildResultsPager":
		resp, err = b.dispatchNewListBuildResultsPager(req)
	case "BuildServiceClient.NewListBuildServicesPager":
		resp, err = b.dispatchNewListBuildServicesPager(req)
	case "BuildServiceClient.NewListBuildsPager":
		resp, err = b.dispatchNewListBuildsPager(req)
	case "BuildServiceClient.ListSupportedBuildpacks":
		resp, err = b.dispatchListSupportedBuildpacks(req)
	case "BuildServiceClient.ListSupportedStacks":
		resp, err = b.dispatchListSupportedStacks(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchCreateOrUpdateBuild(req *http.Request) (*http.Response, error) {
	if b.srv.CreateOrUpdateBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateBuild not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<buildName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappplatform.Build](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	buildNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.CreateOrUpdateBuild(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, buildNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Build, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchGetBuild(req *http.Request) (*http.Response, error) {
	if b.srv.GetBuild == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBuild not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<buildName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	buildNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetBuild(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, buildNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Build, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchGetBuildResult(req *http.Request) (*http.Response, error) {
	if b.srv.GetBuildResult == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBuildResult not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<buildName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/results/(?P<buildResultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	buildNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildName")])
	if err != nil {
		return nil, err
	}
	buildResultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildResultName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetBuildResult(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, buildNameParam, buildResultNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BuildResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchGetBuildResultLog(req *http.Request) (*http.Response, error) {
	if b.srv.GetBuildResultLog == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBuildResultLog not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<buildName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/results/(?P<buildResultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getLogFileUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	buildNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildName")])
	if err != nil {
		return nil, err
	}
	buildResultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildResultName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetBuildResultLog(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, buildNameParam, buildResultNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BuildResultLog, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchGetBuildService(req *http.Request) (*http.Response, error) {
	if b.srv.GetBuildService == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBuildService not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetBuildService(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BuildService, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchGetResourceUploadURL(req *http.Request) (*http.Response, error) {
	if b.srv.GetResourceUploadURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetResourceUploadURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getResourceUploadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetResourceUploadURL(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourceUploadDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchGetSupportedBuildpack(req *http.Request) (*http.Response, error) {
	if b.srv.GetSupportedBuildpack == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSupportedBuildpack not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/supportedBuildpacks/(?P<buildpackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	buildpackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildpackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetSupportedBuildpack(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, buildpackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SupportedBuildpackResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchGetSupportedStack(req *http.Request) (*http.Response, error) {
	if b.srv.GetSupportedStack == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSupportedStack not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/supportedStacks/(?P<stackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	stackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("stackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetSupportedStack(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, stackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SupportedStackResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchNewListBuildResultsPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListBuildResultsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBuildResultsPager not implemented")}
	}
	newListBuildResultsPager := b.newListBuildResultsPager.get(req)
	if newListBuildResultsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<buildName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/results`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
		if err != nil {
			return nil, err
		}
		buildNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildName")])
		if err != nil {
			return nil, err
		}
		resp := b.srv.NewListBuildResultsPager(resourceGroupNameParam, serviceNameParam, buildServiceNameParam, buildNameParam, nil)
		newListBuildResultsPager = &resp
		b.newListBuildResultsPager.add(req, newListBuildResultsPager)
		server.PagerResponderInjectNextLinks(newListBuildResultsPager, req, func(page *armappplatform.BuildServiceClientListBuildResultsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBuildResultsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListBuildResultsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBuildResultsPager) {
		b.newListBuildResultsPager.remove(req)
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchNewListBuildServicesPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListBuildServicesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBuildServicesPager not implemented")}
	}
	newListBuildServicesPager := b.newListBuildServicesPager.get(req)
	if newListBuildServicesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		resp := b.srv.NewListBuildServicesPager(resourceGroupNameParam, serviceNameParam, nil)
		newListBuildServicesPager = &resp
		b.newListBuildServicesPager.add(req, newListBuildServicesPager)
		server.PagerResponderInjectNextLinks(newListBuildServicesPager, req, func(page *armappplatform.BuildServiceClientListBuildServicesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBuildServicesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListBuildServicesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBuildServicesPager) {
		b.newListBuildServicesPager.remove(req)
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchNewListBuildsPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListBuildsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBuildsPager not implemented")}
	}
	newListBuildsPager := b.newListBuildsPager.get(req)
	if newListBuildsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
		if err != nil {
			return nil, err
		}
		resp := b.srv.NewListBuildsPager(resourceGroupNameParam, serviceNameParam, buildServiceNameParam, nil)
		newListBuildsPager = &resp
		b.newListBuildsPager.add(req, newListBuildsPager)
		server.PagerResponderInjectNextLinks(newListBuildsPager, req, func(page *armappplatform.BuildServiceClientListBuildsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBuildsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListBuildsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBuildsPager) {
		b.newListBuildsPager.remove(req)
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchListSupportedBuildpacks(req *http.Request) (*http.Response, error) {
	if b.srv.ListSupportedBuildpacks == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSupportedBuildpacks not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/supportedBuildpacks`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.ListSupportedBuildpacks(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SupportedBuildpacksCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BuildServiceServerTransport) dispatchListSupportedStacks(req *http.Request) (*http.Response, error) {
	if b.srv.ListSupportedStacks == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSupportedStacks not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/buildServices/(?P<buildServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/supportedStacks`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	buildServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildServiceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.ListSupportedStacks(req.Context(), resourceGroupNameParam, serviceNameParam, buildServiceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SupportedStacksCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
