//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datamigration/armdatamigration"
	"net/http"
	"regexp"
)

// ResourceSKUsServer is a fake server for instances of the armdatamigration.ResourceSKUsClient type.
type ResourceSKUsServer struct {
	// NewListSKUsPager is the fake for method ResourceSKUsClient.NewListSKUsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSKUsPager func(options *armdatamigration.ResourceSKUsClientListSKUsOptions) (resp azfake.PagerResponder[armdatamigration.ResourceSKUsClientListSKUsResponse])
}

// NewResourceSKUsServerTransport creates a new instance of ResourceSKUsServerTransport with the provided implementation.
// The returned ResourceSKUsServerTransport instance is connected to an instance of armdatamigration.ResourceSKUsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourceSKUsServerTransport(srv *ResourceSKUsServer) *ResourceSKUsServerTransport {
	return &ResourceSKUsServerTransport{
		srv:              srv,
		newListSKUsPager: newTracker[azfake.PagerResponder[armdatamigration.ResourceSKUsClientListSKUsResponse]](),
	}
}

// ResourceSKUsServerTransport connects instances of armdatamigration.ResourceSKUsClient to instances of ResourceSKUsServer.
// Don't use this type directly, use NewResourceSKUsServerTransport instead.
type ResourceSKUsServerTransport struct {
	srv              *ResourceSKUsServer
	newListSKUsPager *tracker[azfake.PagerResponder[armdatamigration.ResourceSKUsClientListSKUsResponse]]
}

// Do implements the policy.Transporter interface for ResourceSKUsServerTransport.
func (r *ResourceSKUsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourceSKUsClient.NewListSKUsPager":
		resp, err = r.dispatchNewListSKUsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourceSKUsServerTransport) dispatchNewListSKUsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListSKUsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSKUsPager not implemented")}
	}
	newListSKUsPager := r.newListSKUsPager.get(req)
	if newListSKUsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataMigration/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := r.srv.NewListSKUsPager(nil)
		newListSKUsPager = &resp
		r.newListSKUsPager.add(req, newListSKUsPager)
		server.PagerResponderInjectNextLinks(newListSKUsPager, req, func(page *armdatamigration.ResourceSKUsClientListSKUsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSKUsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListSKUsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSKUsPager) {
		r.newListSKUsPager.remove(req)
	}
	return resp, nil
}
