//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmediaservices_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/asset-tracks-list-all.json
func ExampleTracksClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTracksClient().NewListPager("contoso", "contosomedia", "ClimbingMountRainer", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AssetTrackCollection = armmediaservices.AssetTrackCollection{
		// 	Value: []*armmediaservices.AssetTrack{
		// 		{
		// 			Name: to.Ptr("video"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets/tracks"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainer/tracks/video"),
		// 			Properties: &armmediaservices.AssetTrackProperties{
		// 				ProvisioningState: to.Ptr(armmediaservices.ProvisioningStateSucceeded),
		// 				Track: &armmediaservices.VideoTrack{
		// 					ODataType: to.Ptr("#Microsoft.Media.VideoTrack"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("audio"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets/tracks"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainer/tracks/audio"),
		// 			Properties: &armmediaservices.AssetTrackProperties{
		// 				ProvisioningState: to.Ptr(armmediaservices.ProvisioningStateSucceeded),
		// 				Track: &armmediaservices.AudioTrack{
		// 					ODataType: to.Ptr("#Microsoft.Media.AudioTrack"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("text1"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets/tracks"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainer/tracks/text1"),
		// 			Properties: &armmediaservices.AssetTrackProperties{
		// 				ProvisioningState: to.Ptr(armmediaservices.ProvisioningStateSucceeded),
		// 				Track: &armmediaservices.TextTrack{
		// 					ODataType: to.Ptr("#Microsoft.Media.TextTrack"),
		// 					DisplayName: to.Ptr("Auto generated"),
		// 					FileName: to.Ptr("auto_generated.ttml"),
		// 					LanguageCode: to.Ptr("en-us"),
		// 					PlayerVisibility: to.Ptr(armmediaservices.VisibilityVisible),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("text2"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/assets/tracks"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainer/tracks/text2"),
		// 			Properties: &armmediaservices.AssetTrackProperties{
		// 				ProvisioningState: to.Ptr(armmediaservices.ProvisioningStateSucceeded),
		// 				Track: &armmediaservices.TextTrack{
		// 					ODataType: to.Ptr("#Microsoft.Media.TextTrack"),
		// 					DisplayName: to.Ptr("user uploaded text track"),
		// 					FileName: to.Ptr("text2.vtt"),
		// 					HlsSettings: &armmediaservices.HlsSettings{
		// 						Default: to.Ptr(true),
		// 						Characteristics: to.Ptr("public.accessibility.transcribes-spoken-dialog,public.easy-to-read"),
		// 						Forced: to.Ptr(true),
		// 					},
		// 					LanguageCode: to.Ptr("en-us"),
		// 					PlayerVisibility: to.Ptr(armmediaservices.VisibilityHidden),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/asset-tracks-get-by-name.json
func ExampleTracksClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTracksClient().Get(ctx, "contoso", "contosomedia", "ClimbingMountRainer", "text1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AssetTrack = armmediaservices.AssetTrack{
	// 	Name: to.Ptr("text1"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/assets/tracks"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainer/tracks/text1"),
	// 	Properties: &armmediaservices.AssetTrackProperties{
	// 		ProvisioningState: to.Ptr(armmediaservices.ProvisioningStateSucceeded),
	// 		Track: &armmediaservices.TextTrack{
	// 			ODataType: to.Ptr("#Microsoft.Media.TextTrack"),
	// 			DisplayName: to.Ptr("Auto generated"),
	// 			FileName: to.Ptr("auto_generated.ttml"),
	// 			LanguageCode: to.Ptr("en-us"),
	// 			PlayerVisibility: to.Ptr(armmediaservices.VisibilityVisible),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/asset-tracks-create.json
func ExampleTracksClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTracksClient().BeginCreateOrUpdate(ctx, "contoso", "contosomedia", "ClimbingMountRainer", "text3", armmediaservices.AssetTrack{
		Properties: &armmediaservices.AssetTrackProperties{
			Track: &armmediaservices.TextTrack{
				ODataType:        to.Ptr("#Microsoft.Media.TextTrack"),
				DisplayName:      to.Ptr("A new track"),
				FileName:         to.Ptr("text3.ttml"),
				PlayerVisibility: to.Ptr(armmediaservices.VisibilityVisible),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AssetTrack = armmediaservices.AssetTrack{
	// 	Name: to.Ptr("text3"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/assets/tracks"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/assets/ClimbingMountRainer/tracks/text3"),
	// 	Properties: &armmediaservices.AssetTrackProperties{
	// 		ProvisioningState: to.Ptr(armmediaservices.ProvisioningStateSucceeded),
	// 		Track: &armmediaservices.TextTrack{
	// 			ODataType: to.Ptr("#Microsoft.Media.TextTrack"),
	// 			DisplayName: to.Ptr("A new track"),
	// 			FileName: to.Ptr("text3.ttml"),
	// 			PlayerVisibility: to.Ptr(armmediaservices.VisibilityVisible),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/asset-tracks-delete.json
func ExampleTracksClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTracksClient().BeginDelete(ctx, "contoso", "contosomedia", "ClimbingMountRainer", "text2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/asset-tracks-update.json
func ExampleTracksClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTracksClient().BeginUpdate(ctx, "contoso", "contosomedia", "ClimbingMountRainer", "text1", armmediaservices.AssetTrack{
		Properties: &armmediaservices.AssetTrackProperties{
			Track: &armmediaservices.TextTrack{
				ODataType:   to.Ptr("#Microsoft.Media.TextTrack"),
				DisplayName: to.Ptr("A new name"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/asset-tracks-update-data.json
func ExampleTracksClient_BeginUpdateTrackData() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTracksClient().BeginUpdateTrackData(ctx, "contoso", "contosomedia", "ClimbingMountRainer", "text2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
