/*
 * This file is part of the MicroPython project, http://micropython.org/
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2016 Damien P. George
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

// This config exists to test that the MICROPY_LONGINT_IMPL_LONGLONG variant
// (i.e. minimal form of "big integer" that's backed by 64-bit int only) builds
// and passes tests.

#define MICROPY_LONGINT_IMPL           (MICROPY_LONGINT_IMPL_LONGLONG)

// We build it on top of REPR C, which uses memory-efficient floating point
// objects encoded directly mp_obj_t (30 bits only).
// Therefore this variant should be built using MICROPY_FORCE_32BIT=1

#define MICROPY_OBJ_REPR               (MICROPY_OBJ_REPR_C)
#define MICROPY_FLOAT_IMPL             (MICROPY_FLOAT_IMPL_FLOAT)
typedef int mp_int_t;
typedef unsigned int mp_uint_t;

// Set base feature level.
#define MICROPY_CONFIG_ROM_LEVEL (MICROPY_CONFIG_ROM_LEVEL_EXTRA_FEATURES)

// Enable extra Unix features.
#include "../mpconfigvariant_common.h"
