import errno
import platform

# This table maps numeric values defined by `py/mperrno.h` to host errno code.
MP_ERRNO_TABLE = {
    1: errno.EPERM,
    2: errno.ENOENT,
    3: errno.ESRCH,
    4: errno.EINTR,
    5: errno.EIO,
    6: errno.ENXIO,
    7: errno.E2BIG,
    8: errno.ENOEXEC,
    9: errno.EBADF,
    10: errno.ECHILD,
    11: errno.EAGAIN,
    12: errno.ENOMEM,
    13: errno.EACCES,
    14: errno.EFAULT,
    16: errno.EBUSY,
    17: errno.EEXIST,
    18: errno.EXDEV,
    19: errno.ENODEV,
    20: errno.ENOTDIR,
    21: errno.EISDIR,
    22: errno.EINVAL,
    23: errno.ENFILE,
    24: errno.EMFILE,
    25: errno.ENOTTY,
    26: errno.ETXTBSY,
    27: errno.EFBIG,
    28: errno.ENOSPC,
    29: errno.ESPIPE,
    30: errno.EROFS,
    31: errno.EMLINK,
    32: errno.EPIPE,
    33: errno.EDOM,
    34: errno.ERANGE,
    95: errno.EOPNOTSUPP,
    97: errno.EAFNOSUPPORT,
    98: errno.EADDRINUSE,
    103: errno.ECONNABORTED,
    104: errno.ECONNRESET,
    105: errno.ENOBUFS,
    106: errno.EISCONN,
    107: errno.ENOTCONN,
    110: errno.ETIMEDOUT,
    111: errno.ECONNREFUSED,
    113: errno.EHOSTUNREACH,
    114: errno.EALREADY,
    115: errno.EINPROGRESS,
    125: errno.ECANCELED,
}
if platform.system() != "Windows":
    MP_ERRNO_TABLE[15] = errno.ENOTBLK
