# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.quota import QuotaMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestQuotaMgmtQuotaOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(QuotaMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_quota_get(self, resource_group):
        response = self.client.quota.get(
            resource_name="str",
            scope="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_quota_begin_create_or_update(self, resource_group):
        response = self.client.quota.begin_create_or_update(
            resource_name="str",
            scope="str",
            create_quota_request={
                "id": "str",
                "name": "str",
                "properties": {
                    "isQuotaApplicable": bool,
                    "limit": "limit_json_object",
                    "name": {"localizedValue": "str", "value": "str"},
                    "properties": {},
                    "quotaPeriod": "str",
                    "resourceType": "str",
                    "unit": "str",
                },
                "type": "str",
            },
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_quota_begin_update(self, resource_group):
        response = self.client.quota.begin_update(
            resource_name="str",
            scope="str",
            create_quota_request={
                "id": "str",
                "name": "str",
                "properties": {
                    "isQuotaApplicable": bool,
                    "limit": "limit_json_object",
                    "name": {"localizedValue": "str", "value": "str"},
                    "properties": {},
                    "quotaPeriod": "str",
                    "resourceType": "str",
                    "unit": "str",
                },
                "type": "str",
            },
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_quota_list(self, resource_group):
        response = self.client.quota.list(
            scope="str",
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
