# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AnimationOutputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the types of animation data to output."""

    BLENDSHAPES = "blendshapes"
    VISEME_ID = "viseme_id"
    EMOTION = "emotion"


class AudioFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of AudioFormat."""

    PCM16 = "pcm16"
    G711_ULAW = "g711_ulaw"
    G711_ALAW = "g711_alaw"


class AudioTimestampType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Output timestamp types supported in audio response content."""

    WORD = "word"
    """Timestamps per word in the output audio."""


class ClientEventType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Client event types used in VoiceLive protocol."""

    SESSION_UPDATE = "session.update"
    INPUT_AUDIO_BUFFER_APPEND = "input_audio_buffer.append"
    INPUT_AUDIO_BUFFER_COMMIT = "input_audio_buffer.commit"
    INPUT_AUDIO_BUFFER_CLEAR = "input_audio_buffer.clear"
    INPUT_AUDIO_TURN_START = "input_audio.turn.start"
    INPUT_AUDIO_TURN_APPEND = "input_audio.turn.append"
    INPUT_AUDIO_TURN_END = "input_audio.turn.end"
    INPUT_AUDIO_TURN_CANCEL = "input_audio.turn.cancel"
    INPUT_AUDIO_CLEAR = "input_audio.clear"
    CONVERSATION_ITEM_CREATE = "conversation.item.create"
    CONVERSATION_ITEM_RETRIEVE = "conversation.item.retrieve"
    CONVERSATION_ITEM_TRUNCATE = "conversation.item.truncate"
    CONVERSATION_ITEM_DELETE = "conversation.item.delete"
    RESPONSE_CREATE = "response.create"
    RESPONSE_CANCEL = "response.cancel"
    SESSION_AVATAR_CONNECT = "session.avatar.connect"


class ContentPartType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ContentPartType."""

    INPUT_TEXT = "input_text"
    INPUT_AUDIO = "input_audio"
    TEXT = "text"
    AUDIO = "audio"


class ItemParamStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ItemParamStatus."""

    IN_PROGRESS = "in_progress"
    COMPLETED = "completed"
    INCOMPLETE = "incomplete"


class ItemType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ItemType."""

    MESSAGE = "message"
    FUNCTION_CALL = "function_call"
    FUNCTION_CALL_OUTPUT = "function_call_output"


class MessageRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of MessageRole."""

    SYSTEM = "system"
    USER = "user"
    ASSISTANT = "assistant"


class Modality(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Modality."""

    TEXT = "text"
    AUDIO = "audio"
    ANIMATION = "animation"
    AVATAR = "avatar"


class OAIVoice(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported OpenAI voice names (string enum)."""

    ALLOY = "alloy"
    ASH = "ash"
    BALLAD = "ballad"
    CORAL = "coral"
    ECHO = "echo"
    SAGE = "sage"
    SHIMMER = "shimmer"
    VERSE = "verse"


class Phi4mmVoice(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Voice identifier for Phi4mm voices."""

    COSYVOICE = "cosyvoice"


class ResponseItemStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ResponseItemStatus."""

    IN_PROGRESS = "in_progress"
    COMPLETED = "completed"
    INCOMPLETE = "incomplete"


class ResponseStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Terminal status of a response."""

    COMPLETED = "completed"
    CANCELLED = "cancelled"
    FAILED = "failed"
    INCOMPLETE = "incomplete"
    IN_PROGRESS = "in_progress"


class ServerEventType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Server event types used in VoiceLive protocol."""

    ERROR = "error"
    SESSION_AVATAR_CONNECTING = "session.avatar.connecting"
    SESSION_CREATED = "session.created"
    SESSION_UPDATED = "session.updated"
    CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_COMPLETED = "conversation.item.input_audio_transcription.completed"
    CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_DELTA = "conversation.item.input_audio_transcription.delta"
    CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_FAILED = "conversation.item.input_audio_transcription.failed"
    CONVERSATION_ITEM_CREATED = "conversation.item.created"
    CONVERSATION_ITEM_RETRIEVED = "conversation.item.retrieved"
    CONVERSATION_ITEM_TRUNCATED = "conversation.item.truncated"
    CONVERSATION_ITEM_DELETED = "conversation.item.deleted"
    INPUT_AUDIO_BUFFER_COMMITTED = "input_audio_buffer.committed"
    INPUT_AUDIO_BUFFER_CLEARED = "input_audio_buffer.cleared"
    INPUT_AUDIO_BUFFER_SPEECH_STARTED = "input_audio_buffer.speech_started"
    INPUT_AUDIO_BUFFER_SPEECH_STOPPED = "input_audio_buffer.speech_stopped"
    RESPONSE_CREATED = "response.created"
    RESPONSE_DONE = "response.done"
    RESPONSE_OUTPUT_ITEM_ADDED = "response.output_item.added"
    RESPONSE_OUTPUT_ITEM_DONE = "response.output_item.done"
    RESPONSE_CONTENT_PART_ADDED = "response.content_part.added"
    RESPONSE_CONTENT_PART_DONE = "response.content_part.done"
    RESPONSE_TEXT_DELTA = "response.text.delta"
    RESPONSE_TEXT_DONE = "response.text.done"
    RESPONSE_AUDIO_TRANSCRIPT_DELTA = "response.audio_transcript.delta"
    RESPONSE_AUDIO_TRANSCRIPT_DONE = "response.audio_transcript.done"
    RESPONSE_AUDIO_DELTA = "response.audio.delta"
    RESPONSE_AUDIO_DONE = "response.audio.done"
    RESPONSE_ANIMATION_BLENDSHAPES_DELTA = "response.animation_blendshapes.delta"
    RESPONSE_ANIMATION_BLENDSHAPES_DONE = "response.animation_blendshapes.done"
    RESPONSE_EMOTION_HYPOTHESIS = "response.emotion_hypothesis"
    RESPONSE_AUDIO_TIMESTAMP_DELTA = "response.audio_timestamp.delta"
    RESPONSE_AUDIO_TIMESTAMP_DONE = "response.audio_timestamp.done"
    RESPONSE_ANIMATION_VISEME_DELTA = "response.animation_viseme.delta"
    RESPONSE_ANIMATION_VISEME_DONE = "response.animation_viseme.done"
    RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA = "response.function_call_arguments.delta"
    RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE = "response.function_call_arguments.done"


class ToolChoiceLiteral(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The available set of mode-level, string literal tool_choice options for the voicelive endpoint."""

    AUTO = "auto"
    """Specifies that the model should freely determine which tool or tools, if any, to call."""
    NONE = "none"
    """Specifies that the model should call no tools whatsoever."""
    REQUIRED = "required"
    """Specifies that the model should call at least one tool."""


class ToolType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The supported tool type discriminators for voicelive tools.
    Currently, only 'function' tools are supported.
    """

    FUNCTION = "function"
