% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.FGR.R
\name{predict.FGR}
\alias{predict.FGR}
\title{Predict subject specific risks (cumulative incidence) based on Fine-Gray regression model}
\usage{
\method{predict}{FGR}(object, newdata, times, ...)
}
\arguments{
\item{object}{Result of call to \code{FGR}}

\item{newdata}{Predictor values of subjects for who to predict risks}

\item{times}{Time points at which to evaluate the risks}

\item{...}{passed to predict.crr}
}
\description{
Predict subject specific risks (cumulative incidence) based on Fine-Gray regression model
}
\examples{
library(prodlim)
library(survival)
set.seed(10)
d <- sampleData(101, outcome = "competing.risk")
tFun<-function(t) {t}
fgr<-FGR(Hist(time, event)~X1+strata(X2)+X6+cov2(X7, tf=tFun),
         data=d, cause=1)
predictRisk(fgr,times=5,newdata=d[1:10])
}
