package ONVIF::Device::Types::RotateOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %DegreeList_of :ATTR(:get<DegreeList>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Mode
        DegreeList
        Extension

    ) ],
    {
        'Mode' => \%Mode_of,
        'DegreeList' => \%DegreeList_of,
        'Extension' => \%Extension_of,
    },
    {
        'Mode' => 'ONVIF::Device::Types::RotateMode',
        'DegreeList' => 'ONVIF::Device::Types::IntList',
        'Extension' => 'ONVIF::Device::Types::RotateOptionsExtension',
    },
    {

        'Mode' => 'Mode',
        'DegreeList' => 'DegreeList',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::RotateOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RotateOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * DegreeList


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::RotateOptions
   Mode => $some_value, # RotateMode
   DegreeList =>  { # ONVIF::Device::Types::IntList
     Items =>  $some_value, # int
   },
   Extension =>  { # ONVIF::Device::Types::RotateOptionsExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

