/* Copyright 2016 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 *
 * RSA 2048 with F4 exponent public key and verification.
 * Private key in rsa2048-F4.pem.
 */

/* First generate a key:
 * # openssl genrsa -out key.pem 2048
 * # openssl rsa -in key.pem -pubout > key.pub
 * Then dump the key:
 * # dumpRSAPublicKey -pub key.pub | xxd -i
 */
const uint8_t rsa_data[] = {
	0x40, 0x00, 0x00, 0x00, 0xeb, 0xb6, 0x8c, 0xb4, 0x3d, 0xbe, 0xa2, 0xde,
	0x0c, 0xa8, 0x6b, 0xcc, 0x1b, 0x58, 0x2e, 0x1b, 0x44, 0x3f, 0xda, 0xdb,
	0x1d, 0xe1, 0xe4, 0xfd, 0x4b, 0xc5, 0x34, 0xc9, 0x7e, 0x58, 0xfc, 0x82,
	0x6d, 0x95, 0x9f, 0x46, 0x01, 0xaf, 0x7c, 0xa1, 0x50, 0xd5, 0x9c, 0x22,
	0xe1, 0x04, 0xcb, 0x41, 0x9a, 0xc4, 0xfe, 0xfa, 0xb6, 0x67, 0x89, 0x0f,
	0xe5, 0x59, 0xa0, 0xd4, 0x55, 0xb3, 0xb1, 0x6f, 0x06, 0x28, 0x68, 0x1b,
	0x0e, 0x25, 0x97, 0x47, 0xc6, 0xbe, 0x46, 0x14, 0x60, 0x77, 0x11, 0x46,
	0xe2, 0x0c, 0x20, 0x59, 0x8c, 0x95, 0x87, 0x62, 0xe8, 0x05, 0xa9, 0xaf,
	0x53, 0xab, 0x19, 0xca, 0xc0, 0xf4, 0x41, 0x05, 0x95, 0x3a, 0x6f, 0xd0,
	0xdd, 0x87, 0xa7, 0xad, 0xcb, 0x5a, 0x43, 0x86, 0xb4, 0xf4, 0xe9, 0x45,
	0x2a, 0x50, 0xe9, 0xe0, 0xf3, 0x16, 0x29, 0x87, 0xd9, 0xec, 0xc5, 0x48,
	0xee, 0xf3, 0x53, 0xec, 0x18, 0x7f, 0x46, 0xdd, 0x4b, 0xb9, 0xf9, 0x4b,
	0xcd, 0xe4, 0x2a, 0xc8, 0x7d, 0x1a, 0x5e, 0x58, 0x8b, 0x55, 0xf8, 0xed,
	0x4d, 0x65, 0xc0, 0x4a, 0x8e, 0x27, 0x2f, 0x97, 0x82, 0x2f, 0x86, 0x69,
	0xcf, 0xde, 0x00, 0x95, 0x0e, 0x90, 0x39, 0x12, 0x3e, 0x69, 0x2b, 0x7f,
	0xd4, 0xc2, 0xb0, 0x4b, 0x89, 0x41, 0xb2, 0x8f, 0xb7, 0xfb, 0xed, 0xf3,
	0x13, 0x1d, 0xb5, 0x01, 0x10, 0x00, 0xdf, 0x3a, 0xbe, 0x0d, 0x1f, 0x12,
	0xd8, 0x9c, 0xeb, 0x30, 0xfa, 0x7e, 0x57, 0xde, 0x95, 0x7e, 0xdf, 0x06,
	0x9f, 0x7e, 0x08, 0xfc, 0x4f, 0xd4, 0xfa, 0x8f, 0x9a, 0x8a, 0xc8, 0x03,
	0xe7, 0xf2, 0xd0, 0x8e, 0x35, 0xb7, 0x33, 0x67, 0x02, 0x77, 0x1e, 0x8f,
	0xe9, 0xc8, 0x80, 0x35, 0x6d, 0x24, 0xa2, 0xf9, 0x1c, 0x05, 0xd8, 0x1e,
	0x79, 0x07, 0x7e, 0xd4, 0x48, 0xb8, 0x95, 0xfd, 0xf8, 0xb4, 0x0b, 0xd6,
	0x29, 0x86, 0xb1, 0x7e, 0xbe, 0xf4, 0xe6, 0xfb, 0x24, 0x62, 0xf1, 0x00,
	0x1c, 0xf1, 0x4a, 0x33, 0xea, 0x90, 0xf9, 0xbc, 0x5d, 0x4a, 0xf1, 0x6b,
	0x07, 0xfe, 0x77, 0x62, 0x60, 0x83, 0xc2, 0x22, 0x54, 0xfa, 0x94, 0xf9,
	0x59, 0x48, 0x62, 0x02, 0xd4, 0x97, 0x53, 0x3e, 0xfb, 0xfc, 0x06, 0x63,
	0xf7, 0x28, 0x75, 0x34, 0x2c, 0xac, 0x98, 0xae, 0x8b, 0x78, 0xbd, 0x3c,
	0x94, 0x58, 0x40, 0xdf, 0x8e, 0xec, 0x13, 0xcd, 0xe7, 0x20, 0xb8, 0x84,
	0xda, 0xbd, 0x8e, 0x76, 0xbd, 0x1a, 0x7d, 0x3d, 0x18, 0x99, 0x91, 0x54,
	0x19, 0xbb, 0xab, 0xbe, 0xc3, 0x8c, 0x0d, 0x23, 0x0b, 0xef, 0x5f, 0x1c,
	0x49, 0xf0, 0xd1, 0x02, 0x81, 0x37, 0xc8, 0x75, 0x2e, 0xb9, 0x41, 0xf3,
	0x90, 0xc4, 0xa2, 0xdc, 0x2f, 0xa2, 0x21, 0xd0, 0x8b, 0x3b, 0x40, 0x3a,
	0xc4, 0x26, 0x7c, 0x7d, 0x7b, 0x79, 0xe2, 0x9b, 0xe3, 0xb7, 0x68, 0xd1,
	0xcf, 0xc7, 0xce, 0x8c, 0x26, 0x8f, 0x2d, 0xd0, 0x89, 0xc3, 0x18, 0xd1,
	0x07, 0x93, 0xa6, 0x1f, 0x9d, 0x13, 0x2a, 0xf2, 0xaf, 0xef, 0xbe, 0xb2,
	0x02, 0x39, 0xd8, 0xd3, 0xeb, 0xdf, 0x97, 0xe7, 0x91, 0xb2, 0xc5, 0xd0,
	0x21, 0x8f, 0xdd, 0x0c, 0x95, 0x30, 0xc0, 0x5b, 0xd6, 0x00, 0xd2, 0x62,
	0x71, 0x89, 0x69, 0x2b, 0x22, 0x67, 0x05, 0x67, 0x1f, 0x02, 0x57, 0x6d,
	0xc6, 0x3f, 0xed, 0xfe, 0x1f, 0x4c, 0x28, 0x7b, 0x36, 0x32, 0x3a, 0xa2,
	0x61, 0xd2, 0x7a, 0xe1, 0xfd, 0x74, 0x02, 0xe3, 0x70, 0x76, 0x02, 0x19,
	0x3a, 0x46, 0xe9, 0x86, 0x50, 0x6e, 0xce, 0x3f, 0x58, 0x0b, 0x0e, 0xef,
	0xcf, 0x5a, 0xa2, 0x66, 0x7a, 0xa2, 0x0e, 0x02, 0x56, 0x87, 0x98, 0x67,
	0x90, 0xf4, 0x9f, 0x3b, 0xf7, 0xaa, 0x1c, 0xd9, 0xda, 0x0d, 0x49, 0x12,
	0x50, 0xa3, 0x70, 0x62,
};

const struct rsa_public_key *rsa_key = (struct rsa_public_key *)rsa_data;
BUILD_ASSERT(sizeof(*rsa_key) == sizeof(rsa_data));

/* SHA-256 sum to verify:
 * # sha256sum README | sed -e 's/\(..\)/0x\1, /mg'
 */
const uint8_t hash[] = {
	0x6c, 0x5f, 0xef, 0x7f, 0x63, 0x1d, 0xb4, 0x35, 0x6c, 0xae, 0x8b, 0x2a,
	0x4e, 0xde, 0xc5, 0xeb, 0x11, 0xba, 0x1f, 0x44, 0x40, 0xb6, 0x3a, 0x52,
	0xf2, 0x70, 0xef, 0xee, 0x44, 0x4b, 0x57, 0x62
};

/* Incorrect hash to test the negative case */
const uint8_t hash_wrong[] = {
	0x61, 0x1b, 0xd2, 0x44, 0xc7, 0x18, 0xa7, 0x2d, 0x0f, 0x2d, 0x3d, 0x0f,
	0xe3, 0xb3, 0xc5, 0xe4, 0x12, 0xc2, 0x7b, 0x1e, 0x05, 0x2c, 0x6f, 0xad,
	0xc4, 0xac, 0x71, 0x55, 0xe8, 0x80, 0x5c, 0x38
};

/* Generate signature using futility:
 * # futility create key.pem
 * # futility sign --type rwsig --prikey key.vbprik2 README README.out
 * # dd skip=56 bs=1 if=README.out | xxd -i
 */
const uint8_t sig[] = {
	0x1a, 0xd8, 0xa0, 0x94, 0x1f, 0x96, 0x8c, 0x40, 0x22, 0xbf, 0xb7, 0xe0,
	0x65, 0x30, 0xf8, 0xe1, 0xef, 0x9e, 0x70, 0x38, 0x02, 0xd9, 0x30, 0x10,
	0x9f, 0xf9, 0x23, 0x34, 0xd8, 0xe3, 0x04, 0xed, 0x10, 0xcb, 0xde, 0x8b,
	0xc3, 0x1e, 0x89, 0x58, 0x24, 0x90, 0xc1, 0x09, 0x3a, 0x08, 0xd9, 0x2f,
	0x5b, 0xe9, 0xbe, 0x0c, 0x23, 0xd6, 0xd0, 0x5d, 0x1e, 0x85, 0x59, 0x62,
	0xcb, 0x14, 0x76, 0x3f, 0x8f, 0xe6, 0xb9, 0xd2, 0xbd, 0x1c, 0xef, 0xd6,
	0xb0, 0x21, 0xaf, 0x3d, 0x93, 0x6d, 0x2d, 0x78, 0x31, 0x87, 0x37, 0xab,
	0xfe, 0xca, 0xe8, 0x32, 0xda, 0x86, 0x67, 0x48, 0x0e, 0xab, 0xd0, 0xdd,
	0x14, 0x39, 0xe5, 0x8e, 0x65, 0xbb, 0x28, 0xe6, 0xcd, 0xb7, 0xad, 0xbe,
	0x86, 0x95, 0xec, 0xf5, 0xc0, 0x00, 0x45, 0x92, 0x3d, 0x67, 0xd7, 0xb6,
	0x30, 0x60, 0x6c, 0x6d, 0x86, 0xb5, 0xb5, 0x97, 0xe7, 0x52, 0xca, 0xa4,
	0x21, 0xae, 0x48, 0xf9, 0x4a, 0xc8, 0xad, 0xeb, 0xd6, 0x0b, 0xa4, 0x58,
	0x61, 0xf2, 0xaf, 0xbc, 0x2a, 0xe6, 0xd7, 0x78, 0x23, 0x66, 0x9c, 0x12,
	0x87, 0x54, 0x30, 0x68, 0x4b, 0xdb, 0xc2, 0x66, 0xf6, 0x4b, 0x49, 0x44,
	0xbd, 0xb9, 0x1a, 0xdc, 0x71, 0x0f, 0xa4, 0x63, 0xfc, 0x56, 0x41, 0x91,
	0xe5, 0x30, 0xb6, 0xa9, 0xe6, 0x8c, 0x6f, 0x91, 0x8e, 0x36, 0xd6, 0x4d,
	0xe1, 0xdd, 0x0e, 0x1d, 0x1a, 0x71, 0x51, 0x68, 0xf6, 0xf3, 0xea, 0x74,
	0x3a, 0x5f, 0x35, 0x6a, 0x0f, 0xd4, 0x86, 0x96, 0x3e, 0x89, 0xab, 0x88,
	0x03, 0x40, 0xe2, 0x2b, 0x72, 0xa5, 0xa5, 0xf7, 0x79, 0xd0, 0x5a, 0xcb,
	0xfa, 0x40, 0x12, 0xe2, 0x0c, 0xf0, 0xfb, 0xd8, 0x9c, 0x41, 0x30, 0xab,
	0x99, 0x5d, 0x26, 0xe0, 0x6a, 0xcf, 0x0b, 0x4b, 0x4f, 0xe4, 0x85, 0xe6,
	0x8d, 0xe3, 0x11, 0xe0,
	/* Padding */
	0x00
};
