/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedDataRow;
import org.hsqldb.DiskNode;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class CachedRow
extends Row {
    static final int NO_POS = -1;
    protected Table tTable;
    int storageSize;
    protected boolean hasDataChanged;
    boolean hasNodesChanged;

    CachedRow() {
    }

    public static CachedRow newCachedRow(Table table, Object[] objectArray) throws HsqlException {
        if (table.isText) {
            return new CachedDataRow(table, objectArray);
        }
        return new CachedRow(table, objectArray);
    }

    CachedRow(Table table, Object[] objectArray) throws HsqlException {
        this.tTable = table;
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, table);
        for (int i = 1; i < n; ++i) {
            node = node.nNext = Node.newNode(this, i, table);
        }
        this.oData = objectArray;
        this.hasNodesChanged = true;
        this.hasDataChanged = true;
    }

    public CachedRow(Table table, RowInputInterface rowInputInterface) throws IOException, HsqlException {
        this.tTable = table;
        this.iPos = rowInputInterface.getPos();
        this.storageSize = rowInputInterface.getSize();
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, rowInputInterface, 0, table);
        for (int i = 1; i < n; ++i) {
            node = node.nNext = Node.newNode(this, rowInputInterface, i, table);
        }
        this.oData = rowInputInterface.readData(this.tTable.getColumnTypes());
    }

    private void readRowInfo(RowInputInterface rowInputInterface) throws IOException, HsqlException {
    }

    @Override
    public void delete() throws HsqlException {
        super.delete();
        this.hasDataChanged = false;
        this.hasNodesChanged = false;
        this.tTable = null;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public void setPos(int n) {
        this.iPos = n;
    }

    void setChanged() {
        this.hasNodesChanged = true;
    }

    @Override
    public boolean hasChanged() {
        return this.hasNodesChanged;
    }

    public Table getTable() {
        return this.tTable;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.tTable.getIndexCount() * 16 + rowOutputInterface.getSize(this);
    }

    @Override
    public void setStorageSize(int n) {
        this.storageSize = n;
    }

    @Override
    public synchronized boolean isKeepInMemory() {
        Node node = this.nPrimaryNode;
        while (node != null) {
            if (node.isRoot()) {
                return true;
            }
            node = node.nNext;
        }
        return false;
    }

    @Override
    synchronized Row getUpdatedRow() throws HsqlException {
        return this.tTable == null ? null : (CachedRow)this.tTable.rowStore.get(this.iPos);
    }

    void setNewNodes() {
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        try {
            this.writeNodes(rowOutputInterface);
            if (this.hasDataChanged) {
                rowOutputInterface.writeData(this.oData, this.tTable);
                rowOutputInterface.writeEnd();
                this.hasDataChanged = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeRowInfo(RowOutputInterface rowOutputInterface) {
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, IntLookup intLookup) {
        rowOutputInterface.writeSize(this.storageSize);
        Node node = this.nPrimaryNode;
        while (node != null) {
            ((DiskNode)node).writeTranslate(rowOutputInterface, intLookup);
            node = node.nNext;
        }
        rowOutputInterface.writeData(this.getData(), this.getTable());
        rowOutputInterface.writeEnd();
    }

    private void writeNodes(RowOutputInterface rowOutputInterface) throws IOException {
        rowOutputInterface.writeSize(this.storageSize);
        Node node = this.nPrimaryNode;
        while (node != null) {
            node.write(rowOutputInterface);
            node = node.nNext;
        }
        this.hasNodesChanged = false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CachedRow) {
            return ((CachedRow)object).iPos == this.iPos;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.iPos;
    }
}

