/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.core.typeahead.TypeAheadTerminalModel;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class JediTermTypeAheadModel
implements TypeAheadTerminalModel {
    @NotNull
    private final Terminal myTerminal;
    @NotNull
    private final TerminalTextBuffer myTerminalTextBuffer;
    @NotNull
    private final SettingsProvider mySettingsProvider;
    @NotNull
    private TypeAheadTerminalModel.ShellType myShellType = TypeAheadTerminalModel.ShellType.Unknown;
    private final List<TerminalModelListener> myTypeAheadListeners = new CopyOnWriteArrayList<TerminalModelListener>();
    private boolean isPredictionsApplied = false;

    public JediTermTypeAheadModel(@NotNull Terminal terminal, @NotNull TerminalTextBuffer textBuffer, @NotNull SettingsProvider settingsProvider) {
        this.myTerminal = terminal;
        this.myTerminalTextBuffer = textBuffer;
        this.mySettingsProvider = settingsProvider;
    }

    public void insertCharacter(char ch, int index) {
        this.isPredictionsApplied = true;
        TerminalLine typeAheadLine = this.getTypeAheadLine();
        TextStyle typeAheadStyle = this.mySettingsProvider.getTypeAheadSettings().getTypeAheadStyle();
        typeAheadLine.insertString(index, new CharBuffer(ch, 1), typeAheadStyle);
        this.setTypeAheadLine(typeAheadLine);
    }

    public void removeCharacters(int from, int count) {
        this.isPredictionsApplied = true;
        TerminalLine typeAheadLine = this.getTypeAheadLine();
        typeAheadLine.deleteCharacters(from, count, TextStyle.EMPTY);
        this.setTypeAheadLine(typeAheadLine);
    }

    public void forceRedraw() {
        this.fireTypeAheadModelChangeEvent();
    }

    public void moveCursor(int index) {
    }

    public void clearPredictions() {
        if (this.isPredictionsApplied) {
            this.myTerminalTextBuffer.clearTypeAheadPredictions();
        }
        this.isPredictionsApplied = false;
    }

    public void lock() {
        this.myTerminalTextBuffer.lock();
    }

    public void unlock() {
        this.myTerminalTextBuffer.unlock();
    }

    public boolean isUsingAlternateBuffer() {
        return this.myTerminalTextBuffer.isUsingAlternateBuffer();
    }

    public boolean isTypeAheadEnabled() {
        return this.mySettingsProvider.getTypeAheadSettings().isEnabled();
    }

    public long getLatencyThreshold() {
        return this.mySettingsProvider.getTypeAheadSettings().getLatencyThreshold();
    }

    @NotNull
    public TypeAheadTerminalModel.ShellType getShellType() {
        return this.myShellType;
    }

    public void setShellType(TypeAheadTerminalModel.ShellType shellType) {
        this.myShellType = shellType;
    }

    @NotNull
    public TypeAheadTerminalModel.LineWithCursorX getCurrentLineWithCursor() {
        TerminalLine terminalLine = this.myTerminalTextBuffer.getLine(this.myTerminal.getCursorY() - 1);
        return new TypeAheadTerminalModel.LineWithCursorX(new StringBuffer(terminalLine.getText()), this.myTerminal.getCursorX() - 1);
    }

    public int getTerminalWidth() {
        return this.myTerminal.getTerminalWidth();
    }

    @NotNull
    private TerminalLine getTypeAheadLine() {
        TerminalLine terminalLine = this.myTerminalTextBuffer.getLine(this.myTerminal.getCursorY() - 1);
        if (terminalLine.myTypeAheadLine != null) {
            terminalLine = terminalLine.myTypeAheadLine;
        }
        return terminalLine.copy();
    }

    private void setTypeAheadLine(@NotNull TerminalLine typeAheadTerminalLine) {
        TerminalLine terminalLine = this.myTerminalTextBuffer.getLine(this.myTerminal.getCursorY() - 1);
        terminalLine.myTypeAheadLine = typeAheadTerminalLine;
    }

    public void addTypeAheadModelListener(@NotNull TerminalModelListener listener) {
        this.myTypeAheadListeners.add(listener);
    }

    public void removeTypeAheadModelListener(@NotNull TerminalModelListener listener) {
        this.myTypeAheadListeners.remove(listener);
    }

    private void fireTypeAheadModelChangeEvent() {
        for (TerminalModelListener typeAheadListener : this.myTypeAheadListeners) {
            typeAheadListener.modelChanged();
        }
    }
}

