from collections.abc import Iterator
from typing import Any

from django.contrib.gis.geos.geometry import GEOSGeometry, LinearGeometryMixin

class LineString(LinearGeometryMixin, GEOSGeometry):
    has_cs: bool
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def __iter__(self) -> Iterator[tuple[float, ...]]: ...
    def __len__(self) -> int: ...
    @property
    def coords(self) -> tuple[tuple[float, ...]]: ...
    @property
    def tuple(self) -> tuple[tuple[float, ...]]: ...
    @property
    def array(self) -> Any: ...
    @property
    def x(self) -> Any: ...
    @property
    def y(self) -> Any: ...
    @property
    def z(self) -> Any: ...

class LinearRing(LineString):
    @property
    def is_counterclockwise(self) -> bool: ...
